package zio.aws.iot.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  IsDefaultVersion,
  TemplateBody,
  DateType,
  TemplateVersionId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeProvisioningTemplateVersionResponse(
    versionId: Option[TemplateVersionId] = None,
    creationDate: Option[DateType] = None,
    templateBody: Option[TemplateBody] = None,
    isDefaultVersion: Option[IsDefaultVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionResponse = {
    import DescribeProvisioningTemplateVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionResponse
      .builder()
      .optionallyWith(
        versionId.map(value => TemplateVersionId.unwrap(value): Integer)
      )(_.versionId)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        isDefaultVersion.map(value =>
          IsDefaultVersion.unwrap(value): java.lang.Boolean
        )
      )(_.isDefaultVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse.ReadOnly =
    zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse
      .wrap(buildAwsValue())
}
object DescribeProvisioningTemplateVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse =
      zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse(
        versionId.map(value => value),
        creationDate.map(value => value),
        templateBody.map(value => value),
        isDefaultVersion.map(value => value)
      )
    def versionId: Option[TemplateVersionId]
    def creationDate: Option[DateType]
    def templateBody: Option[TemplateBody]
    def isDefaultVersion: Option[IsDefaultVersion]
    def getVersionId: ZIO[Any, AwsError, TemplateVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getIsDefaultVersion: ZIO[Any, AwsError, IsDefaultVersion] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionResponse
  ) extends zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse.ReadOnly {
    override val versionId: Option[TemplateVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.iot.model.primitives.TemplateVersionId(value))
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val templateBody: Option[TemplateBody] = scala
      .Option(impl.templateBody())
      .map(value => zio.aws.iot.model.primitives.TemplateBody(value))
    override val isDefaultVersion: Option[IsDefaultVersion] = scala
      .Option(impl.isDefaultVersion())
      .map(value => zio.aws.iot.model.primitives.IsDefaultVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionResponse
  ): zio.aws.iot.model.DescribeProvisioningTemplateVersionResponse.ReadOnly =
    new Wrapper(impl)
}
