package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeRoleAliasResponse(
    roleAliasDescription: Option[zio.aws.iot.model.RoleAliasDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeRoleAliasResponse = {
    import DescribeRoleAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeRoleAliasResponse
      .builder()
      .optionallyWith(roleAliasDescription.map(value => value.buildAwsValue()))(
        _.roleAliasDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeRoleAliasResponse.ReadOnly =
    zio.aws.iot.model.DescribeRoleAliasResponse.wrap(buildAwsValue())
}
object DescribeRoleAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeRoleAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeRoleAliasResponse =
      zio.aws.iot.model.DescribeRoleAliasResponse(
        roleAliasDescription.map(value => value.asEditable)
      )
    def roleAliasDescription
        : Option[zio.aws.iot.model.RoleAliasDescription.ReadOnly]
    def getRoleAliasDescription
        : ZIO[Any, AwsError, zio.aws.iot.model.RoleAliasDescription.ReadOnly] =
      AwsError.unwrapOptionField("roleAliasDescription", roleAliasDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeRoleAliasResponse
  ) extends zio.aws.iot.model.DescribeRoleAliasResponse.ReadOnly {
    override val roleAliasDescription
        : Option[zio.aws.iot.model.RoleAliasDescription.ReadOnly] = scala
      .Option(impl.roleAliasDescription())
      .map(value => zio.aws.iot.model.RoleAliasDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeRoleAliasResponse
  ): zio.aws.iot.model.DescribeRoleAliasResponse.ReadOnly = new Wrapper(impl)
}
