package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ScheduledAuditArn,
  ScheduledAuditName,
  AuditCheckName,
  DayOfMonth
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeScheduledAuditResponse(
    frequency: Option[zio.aws.iot.model.AuditFrequency] = None,
    dayOfMonth: Option[DayOfMonth] = None,
    dayOfWeek: Option[zio.aws.iot.model.DayOfWeek] = None,
    targetCheckNames: Option[Iterable[AuditCheckName]] = None,
    scheduledAuditName: Option[ScheduledAuditName] = None,
    scheduledAuditArn: Option[ScheduledAuditArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeScheduledAuditResponse = {
    import DescribeScheduledAuditResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeScheduledAuditResponse
      .builder()
      .optionallyWith(frequency.map(value => value.unwrap))(_.frequency)
      .optionallyWith(
        dayOfMonth.map(value => DayOfMonth.unwrap(value): java.lang.String)
      )(_.dayOfMonth)
      .optionallyWith(dayOfWeek.map(value => value.unwrap))(_.dayOfWeek)
      .optionallyWith(
        targetCheckNames.map(value =>
          value.map { item =>
            AuditCheckName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetCheckNames)
      .optionallyWith(
        scheduledAuditName.map(value =>
          ScheduledAuditName.unwrap(value): java.lang.String
        )
      )(_.scheduledAuditName)
      .optionallyWith(
        scheduledAuditArn.map(value =>
          ScheduledAuditArn.unwrap(value): java.lang.String
        )
      )(_.scheduledAuditArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeScheduledAuditResponse.ReadOnly =
    zio.aws.iot.model.DescribeScheduledAuditResponse.wrap(buildAwsValue())
}
object DescribeScheduledAuditResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeScheduledAuditResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeScheduledAuditResponse =
      zio.aws.iot.model.DescribeScheduledAuditResponse(
        frequency.map(value => value),
        dayOfMonth.map(value => value),
        dayOfWeek.map(value => value),
        targetCheckNames.map(value => value),
        scheduledAuditName.map(value => value),
        scheduledAuditArn.map(value => value)
      )
    def frequency: Option[zio.aws.iot.model.AuditFrequency]
    def dayOfMonth: Option[DayOfMonth]
    def dayOfWeek: Option[zio.aws.iot.model.DayOfWeek]
    def targetCheckNames: Option[List[AuditCheckName]]
    def scheduledAuditName: Option[ScheduledAuditName]
    def scheduledAuditArn: Option[ScheduledAuditArn]
    def getFrequency: ZIO[Any, AwsError, zio.aws.iot.model.AuditFrequency] =
      AwsError.unwrapOptionField("frequency", frequency)
    def getDayOfMonth: ZIO[Any, AwsError, DayOfMonth] =
      AwsError.unwrapOptionField("dayOfMonth", dayOfMonth)
    def getDayOfWeek: ZIO[Any, AwsError, zio.aws.iot.model.DayOfWeek] =
      AwsError.unwrapOptionField("dayOfWeek", dayOfWeek)
    def getTargetCheckNames: ZIO[Any, AwsError, List[AuditCheckName]] =
      AwsError.unwrapOptionField("targetCheckNames", targetCheckNames)
    def getScheduledAuditName: ZIO[Any, AwsError, ScheduledAuditName] =
      AwsError.unwrapOptionField("scheduledAuditName", scheduledAuditName)
    def getScheduledAuditArn: ZIO[Any, AwsError, ScheduledAuditArn] =
      AwsError.unwrapOptionField("scheduledAuditArn", scheduledAuditArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeScheduledAuditResponse
  ) extends zio.aws.iot.model.DescribeScheduledAuditResponse.ReadOnly {
    override val frequency: Option[zio.aws.iot.model.AuditFrequency] = scala
      .Option(impl.frequency())
      .map(value => zio.aws.iot.model.AuditFrequency.wrap(value))
    override val dayOfMonth: Option[DayOfMonth] = scala
      .Option(impl.dayOfMonth())
      .map(value => zio.aws.iot.model.primitives.DayOfMonth(value))
    override val dayOfWeek: Option[zio.aws.iot.model.DayOfWeek] = scala
      .Option(impl.dayOfWeek())
      .map(value => zio.aws.iot.model.DayOfWeek.wrap(value))
    override val targetCheckNames: Option[List[AuditCheckName]] = scala
      .Option(impl.targetCheckNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.AuditCheckName(item)
        }.toList
      )
    override val scheduledAuditName: Option[ScheduledAuditName] = scala
      .Option(impl.scheduledAuditName())
      .map(value => zio.aws.iot.model.primitives.ScheduledAuditName(value))
    override val scheduledAuditArn: Option[ScheduledAuditArn] = scala
      .Option(impl.scheduledAuditArn())
      .map(value => zio.aws.iot.model.primitives.ScheduledAuditArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeScheduledAuditResponse
  ): zio.aws.iot.model.DescribeScheduledAuditResponse.ReadOnly = new Wrapper(
    impl
  )
}
