package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  SecurityProfileDescription,
  Timestamp,
  SecurityProfileArn,
  SecurityProfileName,
  Version,
  BehaviorMetric
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DescribeSecurityProfileResponse(
    securityProfileName: Option[SecurityProfileName] = None,
    securityProfileArn: Option[SecurityProfileArn] = None,
    securityProfileDescription: Option[SecurityProfileDescription] = None,
    behaviors: Option[Iterable[zio.aws.iot.model.Behavior]] = None,
    alertTargets: Option[
      Map[zio.aws.iot.model.AlertTargetType, zio.aws.iot.model.AlertTarget]
    ] = None,
    additionalMetricsToRetain: Option[Iterable[BehaviorMetric]] = None,
    additionalMetricsToRetainV2: Option[
      Iterable[zio.aws.iot.model.MetricToRetain]
    ] = None,
    version: Option[Version] = None,
    creationDate: Option[Timestamp] = None,
    lastModifiedDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeSecurityProfileResponse = {
    import DescribeSecurityProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeSecurityProfileResponse
      .builder()
      .optionallyWith(
        securityProfileName.map(value =>
          SecurityProfileName.unwrap(value): java.lang.String
        )
      )(_.securityProfileName)
      .optionallyWith(
        securityProfileArn.map(value =>
          SecurityProfileArn.unwrap(value): java.lang.String
        )
      )(_.securityProfileArn)
      .optionallyWith(
        securityProfileDescription.map(value =>
          SecurityProfileDescription.unwrap(value): java.lang.String
        )
      )(_.securityProfileDescription)
      .optionallyWith(
        behaviors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.behaviors)
      .optionallyWith(
        alertTargets.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.alertTargetsWithStrings)
      .optionallyWith(
        additionalMetricsToRetain.map(value =>
          value.map { item =>
            BehaviorMetric.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalMetricsToRetain)
      .optionallyWith(
        additionalMetricsToRetainV2.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalMetricsToRetainV2)
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeSecurityProfileResponse.ReadOnly =
    zio.aws.iot.model.DescribeSecurityProfileResponse.wrap(buildAwsValue())
}
object DescribeSecurityProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeSecurityProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeSecurityProfileResponse =
      zio.aws.iot.model.DescribeSecurityProfileResponse(
        securityProfileName.map(value => value),
        securityProfileArn.map(value => value),
        securityProfileDescription.map(value => value),
        behaviors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        alertTargets.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        additionalMetricsToRetain.map(value => value),
        additionalMetricsToRetainV2.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        version.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def securityProfileName: Option[SecurityProfileName]
    def securityProfileArn: Option[SecurityProfileArn]
    def securityProfileDescription: Option[SecurityProfileDescription]
    def behaviors: Option[List[zio.aws.iot.model.Behavior.ReadOnly]]
    def alertTargets: Option[Map[
      zio.aws.iot.model.AlertTargetType,
      zio.aws.iot.model.AlertTarget.ReadOnly
    ]]
    def additionalMetricsToRetain: Option[List[BehaviorMetric]]
    def additionalMetricsToRetainV2
        : Option[List[zio.aws.iot.model.MetricToRetain.ReadOnly]]
    def version: Option[Version]
    def creationDate: Option[Timestamp]
    def lastModifiedDate: Option[Timestamp]
    def getSecurityProfileName: ZIO[Any, AwsError, SecurityProfileName] =
      AwsError.unwrapOptionField("securityProfileName", securityProfileName)
    def getSecurityProfileArn: ZIO[Any, AwsError, SecurityProfileArn] =
      AwsError.unwrapOptionField("securityProfileArn", securityProfileArn)
    def getSecurityProfileDescription
        : ZIO[Any, AwsError, SecurityProfileDescription] =
      AwsError.unwrapOptionField(
        "securityProfileDescription",
        securityProfileDescription
      )
    def getBehaviors
        : ZIO[Any, AwsError, List[zio.aws.iot.model.Behavior.ReadOnly]] =
      AwsError.unwrapOptionField("behaviors", behaviors)
    def getAlertTargets: ZIO[Any, AwsError, Map[
      zio.aws.iot.model.AlertTargetType,
      zio.aws.iot.model.AlertTarget.ReadOnly
    ]] = AwsError.unwrapOptionField("alertTargets", alertTargets)
    def getAdditionalMetricsToRetain: ZIO[Any, AwsError, List[BehaviorMetric]] =
      AwsError.unwrapOptionField(
        "additionalMetricsToRetain",
        additionalMetricsToRetain
      )
    def getAdditionalMetricsToRetainV2
        : ZIO[Any, AwsError, List[zio.aws.iot.model.MetricToRetain.ReadOnly]] =
      AwsError.unwrapOptionField(
        "additionalMetricsToRetainV2",
        additionalMetricsToRetainV2
      )
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeSecurityProfileResponse
  ) extends zio.aws.iot.model.DescribeSecurityProfileResponse.ReadOnly {
    override val securityProfileName: Option[SecurityProfileName] = scala
      .Option(impl.securityProfileName())
      .map(value => zio.aws.iot.model.primitives.SecurityProfileName(value))
    override val securityProfileArn: Option[SecurityProfileArn] = scala
      .Option(impl.securityProfileArn())
      .map(value => zio.aws.iot.model.primitives.SecurityProfileArn(value))
    override val securityProfileDescription
        : Option[SecurityProfileDescription] = scala
      .Option(impl.securityProfileDescription())
      .map(value =>
        zio.aws.iot.model.primitives.SecurityProfileDescription(value)
      )
    override val behaviors: Option[List[zio.aws.iot.model.Behavior.ReadOnly]] =
      scala
        .Option(impl.behaviors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Behavior.wrap(item)
          }.toList
        )
    override val alertTargets: Option[Map[
      zio.aws.iot.model.AlertTargetType,
      zio.aws.iot.model.AlertTarget.ReadOnly
    ]] = scala
      .Option(impl.alertTargets())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.AlertTargetType
              .wrap(key) -> zio.aws.iot.model.AlertTarget.wrap(value)
          })
          .toMap
      )
    override val additionalMetricsToRetain: Option[List[BehaviorMetric]] = scala
      .Option(impl.additionalMetricsToRetain())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.BehaviorMetric(item)
        }.toList
      )
    override val additionalMetricsToRetainV2
        : Option[List[zio.aws.iot.model.MetricToRetain.ReadOnly]] = scala
      .Option(impl.additionalMetricsToRetainV2())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.MetricToRetain.wrap(item)
        }.toList
      )
    override val version: Option[Version] = scala
      .Option(impl.version())
      .map(value => zio.aws.iot.model.primitives.Version(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val lastModifiedDate: Option[Timestamp] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeSecurityProfileResponse
  ): zio.aws.iot.model.DescribeSecurityProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
