package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeStreamResponse(
    streamInfo: Option[zio.aws.iot.model.StreamInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeStreamResponse = {
    import DescribeStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeStreamResponse
      .builder()
      .optionallyWith(streamInfo.map(value => value.buildAwsValue()))(
        _.streamInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeStreamResponse.ReadOnly =
    zio.aws.iot.model.DescribeStreamResponse.wrap(buildAwsValue())
}
object DescribeStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeStreamResponse = zio.aws.iot.model
      .DescribeStreamResponse(streamInfo.map(value => value.asEditable))
    def streamInfo: Option[zio.aws.iot.model.StreamInfo.ReadOnly]
    def getStreamInfo
        : ZIO[Any, AwsError, zio.aws.iot.model.StreamInfo.ReadOnly] =
      AwsError.unwrapOptionField("streamInfo", streamInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeStreamResponse
  ) extends zio.aws.iot.model.DescribeStreamResponse.ReadOnly {
    override val streamInfo: Option[zio.aws.iot.model.StreamInfo.ReadOnly] =
      scala
        .Option(impl.streamInfo())
        .map(value => zio.aws.iot.model.StreamInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeStreamResponse
  ): zio.aws.iot.model.DescribeStreamResponse.ReadOnly = new Wrapper(impl)
}
