package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ThingGroupId,
  IndexName,
  ThingGroupArn,
  Version,
  QueryVersion,
  QueryString,
  ThingGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeThingGroupResponse(
    thingGroupName: Option[ThingGroupName] = None,
    thingGroupId: Option[ThingGroupId] = None,
    thingGroupArn: Option[ThingGroupArn] = None,
    version: Option[Version] = None,
    thingGroupProperties: Option[zio.aws.iot.model.ThingGroupProperties] = None,
    thingGroupMetadata: Option[zio.aws.iot.model.ThingGroupMetadata] = None,
    indexName: Option[IndexName] = None,
    queryString: Option[QueryString] = None,
    queryVersion: Option[QueryVersion] = None,
    status: Option[zio.aws.iot.model.DynamicGroupStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeThingGroupResponse = {
    import DescribeThingGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeThingGroupResponse
      .builder()
      .optionallyWith(
        thingGroupName.map(value =>
          ThingGroupName.unwrap(value): java.lang.String
        )
      )(_.thingGroupName)
      .optionallyWith(
        thingGroupId.map(value => ThingGroupId.unwrap(value): java.lang.String)
      )(_.thingGroupId)
      .optionallyWith(
        thingGroupArn.map(value =>
          ThingGroupArn.unwrap(value): java.lang.String
        )
      )(_.thingGroupArn)
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(thingGroupProperties.map(value => value.buildAwsValue()))(
        _.thingGroupProperties
      )
      .optionallyWith(thingGroupMetadata.map(value => value.buildAwsValue()))(
        _.thingGroupMetadata
      )
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        queryString.map(value => QueryString.unwrap(value): java.lang.String)
      )(_.queryString)
      .optionallyWith(
        queryVersion.map(value => QueryVersion.unwrap(value): java.lang.String)
      )(_.queryVersion)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeThingGroupResponse.ReadOnly =
    zio.aws.iot.model.DescribeThingGroupResponse.wrap(buildAwsValue())
}
object DescribeThingGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeThingGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeThingGroupResponse =
      zio.aws.iot.model.DescribeThingGroupResponse(
        thingGroupName.map(value => value),
        thingGroupId.map(value => value),
        thingGroupArn.map(value => value),
        version.map(value => value),
        thingGroupProperties.map(value => value.asEditable),
        thingGroupMetadata.map(value => value.asEditable),
        indexName.map(value => value),
        queryString.map(value => value),
        queryVersion.map(value => value),
        status.map(value => value)
      )
    def thingGroupName: Option[ThingGroupName]
    def thingGroupId: Option[ThingGroupId]
    def thingGroupArn: Option[ThingGroupArn]
    def version: Option[Version]
    def thingGroupProperties
        : Option[zio.aws.iot.model.ThingGroupProperties.ReadOnly]
    def thingGroupMetadata
        : Option[zio.aws.iot.model.ThingGroupMetadata.ReadOnly]
    def indexName: Option[IndexName]
    def queryString: Option[QueryString]
    def queryVersion: Option[QueryVersion]
    def status: Option[zio.aws.iot.model.DynamicGroupStatus]
    def getThingGroupName: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("thingGroupName", thingGroupName)
    def getThingGroupId: ZIO[Any, AwsError, ThingGroupId] =
      AwsError.unwrapOptionField("thingGroupId", thingGroupId)
    def getThingGroupArn: ZIO[Any, AwsError, ThingGroupArn] =
      AwsError.unwrapOptionField("thingGroupArn", thingGroupArn)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getThingGroupProperties
        : ZIO[Any, AwsError, zio.aws.iot.model.ThingGroupProperties.ReadOnly] =
      AwsError.unwrapOptionField("thingGroupProperties", thingGroupProperties)
    def getThingGroupMetadata
        : ZIO[Any, AwsError, zio.aws.iot.model.ThingGroupMetadata.ReadOnly] =
      AwsError.unwrapOptionField("thingGroupMetadata", thingGroupMetadata)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getQueryString: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getQueryVersion: ZIO[Any, AwsError, QueryVersion] =
      AwsError.unwrapOptionField("queryVersion", queryVersion)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.DynamicGroupStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingGroupResponse
  ) extends zio.aws.iot.model.DescribeThingGroupResponse.ReadOnly {
    override val thingGroupName: Option[ThingGroupName] = scala
      .Option(impl.thingGroupName())
      .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val thingGroupId: Option[ThingGroupId] = scala
      .Option(impl.thingGroupId())
      .map(value => zio.aws.iot.model.primitives.ThingGroupId(value))
    override val thingGroupArn: Option[ThingGroupArn] = scala
      .Option(impl.thingGroupArn())
      .map(value => zio.aws.iot.model.primitives.ThingGroupArn(value))
    override val version: Option[Version] = scala
      .Option(impl.version())
      .map(value => zio.aws.iot.model.primitives.Version(value))
    override val thingGroupProperties
        : Option[zio.aws.iot.model.ThingGroupProperties.ReadOnly] = scala
      .Option(impl.thingGroupProperties())
      .map(value => zio.aws.iot.model.ThingGroupProperties.wrap(value))
    override val thingGroupMetadata
        : Option[zio.aws.iot.model.ThingGroupMetadata.ReadOnly] = scala
      .Option(impl.thingGroupMetadata())
      .map(value => zio.aws.iot.model.ThingGroupMetadata.wrap(value))
    override val indexName: Option[IndexName] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.iot.model.primitives.IndexName(value))
    override val queryString: Option[QueryString] = scala
      .Option(impl.queryString())
      .map(value => zio.aws.iot.model.primitives.QueryString(value))
    override val queryVersion: Option[QueryVersion] = scala
      .Option(impl.queryVersion())
      .map(value => zio.aws.iot.model.primitives.QueryVersion(value))
    override val status: Option[zio.aws.iot.model.DynamicGroupStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.DynamicGroupStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingGroupResponse
  ): zio.aws.iot.model.DescribeThingGroupResponse.ReadOnly = new Wrapper(impl)
}
