package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ThingName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeThingRequest(thingName: ThingName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeThingRequest = {
    import DescribeThingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeThingRequest
      .builder()
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeThingRequest.ReadOnly =
    zio.aws.iot.model.DescribeThingRequest.wrap(buildAwsValue())
}
object DescribeThingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeThingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeThingRequest =
      zio.aws.iot.model.DescribeThingRequest(thingName)
    def thingName: ThingName
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingRequest
  ) extends zio.aws.iot.model.DescribeThingRequest.ReadOnly {
    override val thingName: ThingName =
      zio.aws.iot.model.primitives.ThingName(impl.thingName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingRequest
  ): zio.aws.iot.model.DescribeThingRequest.ReadOnly = new Wrapper(impl)
}
