package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Destination(
    s3Destination: Option[zio.aws.iot.model.S3Destination] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Destination = {
    import Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Destination
      .builder()
      .optionallyWith(s3Destination.map(value => value.buildAwsValue()))(
        _.s3Destination
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Destination.ReadOnly =
    zio.aws.iot.model.Destination.wrap(buildAwsValue())
}
object Destination {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Destination] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Destination = zio.aws.iot.model
      .Destination(s3Destination.map(value => value.asEditable))
    def s3Destination: Option[zio.aws.iot.model.S3Destination.ReadOnly]
    def getS3Destination
        : ZIO[Any, AwsError, zio.aws.iot.model.S3Destination.ReadOnly] =
      AwsError.unwrapOptionField("s3Destination", s3Destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Destination
  ) extends zio.aws.iot.model.Destination.ReadOnly {
    override val s3Destination
        : Option[zio.aws.iot.model.S3Destination.ReadOnly] = scala
      .Option(impl.s3Destination())
      .map(value => zio.aws.iot.model.S3Destination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Destination
  ): zio.aws.iot.model.Destination.ReadOnly = new Wrapper(impl)
}
