package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  BehaviorName,
  SecurityProfileName,
  ViolationId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DetectMitigationActionsTaskTarget(
    violationIds: Option[Iterable[ViolationId]] = None,
    securityProfileName: Option[SecurityProfileName] = None,
    behaviorName: Option[BehaviorName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskTarget = {
    import DetectMitigationActionsTaskTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskTarget
      .builder()
      .optionallyWith(
        violationIds.map(value =>
          value.map { item =>
            ViolationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.violationIds)
      .optionallyWith(
        securityProfileName.map(value =>
          SecurityProfileName.unwrap(value): java.lang.String
        )
      )(_.securityProfileName)
      .optionallyWith(
        behaviorName.map(value => BehaviorName.unwrap(value): java.lang.String)
      )(_.behaviorName)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DetectMitigationActionsTaskTarget.ReadOnly =
    zio.aws.iot.model.DetectMitigationActionsTaskTarget.wrap(buildAwsValue())
}
object DetectMitigationActionsTaskTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DetectMitigationActionsTaskTarget =
      zio.aws.iot.model.DetectMitigationActionsTaskTarget(
        violationIds.map(value => value),
        securityProfileName.map(value => value),
        behaviorName.map(value => value)
      )
    def violationIds: Option[List[ViolationId]]
    def securityProfileName: Option[SecurityProfileName]
    def behaviorName: Option[BehaviorName]
    def getViolationIds: ZIO[Any, AwsError, List[ViolationId]] =
      AwsError.unwrapOptionField("violationIds", violationIds)
    def getSecurityProfileName: ZIO[Any, AwsError, SecurityProfileName] =
      AwsError.unwrapOptionField("securityProfileName", securityProfileName)
    def getBehaviorName: ZIO[Any, AwsError, BehaviorName] =
      AwsError.unwrapOptionField("behaviorName", behaviorName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskTarget
  ) extends zio.aws.iot.model.DetectMitigationActionsTaskTarget.ReadOnly {
    override val violationIds: Option[List[ViolationId]] = scala
      .Option(impl.violationIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.ViolationId(item)
        }.toList
      )
    override val securityProfileName: Option[SecurityProfileName] = scala
      .Option(impl.securityProfileName())
      .map(value => zio.aws.iot.model.primitives.SecurityProfileName(value))
    override val behaviorName: Option[BehaviorName] = scala
      .Option(impl.behaviorName())
      .map(value => zio.aws.iot.model.primitives.BehaviorName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskTarget
  ): zio.aws.iot.model.DetectMitigationActionsTaskTarget.ReadOnly = new Wrapper(
    impl
  )
}
