package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.RuleName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisableTopicRuleRequest(ruleName: RuleName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DisableTopicRuleRequest = {
    import DisableTopicRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DisableTopicRuleRequest
      .builder()
      .ruleName(RuleName.unwrap(ruleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DisableTopicRuleRequest.ReadOnly =
    zio.aws.iot.model.DisableTopicRuleRequest.wrap(buildAwsValue())
}
object DisableTopicRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DisableTopicRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DisableTopicRuleRequest =
      zio.aws.iot.model.DisableTopicRuleRequest(ruleName)
    def ruleName: RuleName
    def getRuleName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(ruleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DisableTopicRuleRequest
  ) extends zio.aws.iot.model.DisableTopicRuleRequest.ReadOnly {
    override val ruleName: RuleName =
      zio.aws.iot.model.primitives.RuleName(impl.ruleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DisableTopicRuleRequest
  ): zio.aws.iot.model.DisableTopicRuleRequest.ReadOnly = new Wrapper(impl)
}
