package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  HashKeyField,
  TableName,
  HashKeyValue,
  PayloadField,
  AwsArn,
  RangeKeyField,
  RangeKeyValue,
  DynamoOperation
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DynamoDBAction(
    tableName: TableName,
    roleArn: AwsArn,
    operation: Option[DynamoOperation] = None,
    hashKeyField: HashKeyField,
    hashKeyValue: HashKeyValue,
    hashKeyType: Option[zio.aws.iot.model.DynamoKeyType] = None,
    rangeKeyField: Option[RangeKeyField] = None,
    rangeKeyValue: Option[RangeKeyValue] = None,
    rangeKeyType: Option[zio.aws.iot.model.DynamoKeyType] = None,
    payloadField: Option[PayloadField] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DynamoDBAction = {
    import DynamoDBAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DynamoDBAction
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        operation.map(value => DynamoOperation.unwrap(value): java.lang.String)
      )(_.operation)
      .hashKeyField(HashKeyField.unwrap(hashKeyField): java.lang.String)
      .hashKeyValue(HashKeyValue.unwrap(hashKeyValue): java.lang.String)
      .optionallyWith(hashKeyType.map(value => value.unwrap))(_.hashKeyType)
      .optionallyWith(
        rangeKeyField.map(value =>
          RangeKeyField.unwrap(value): java.lang.String
        )
      )(_.rangeKeyField)
      .optionallyWith(
        rangeKeyValue.map(value =>
          RangeKeyValue.unwrap(value): java.lang.String
        )
      )(_.rangeKeyValue)
      .optionallyWith(rangeKeyType.map(value => value.unwrap))(_.rangeKeyType)
      .optionallyWith(
        payloadField.map(value => PayloadField.unwrap(value): java.lang.String)
      )(_.payloadField)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DynamoDBAction.ReadOnly =
    zio.aws.iot.model.DynamoDBAction.wrap(buildAwsValue())
}
object DynamoDBAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DynamoDBAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DynamoDBAction =
      zio.aws.iot.model.DynamoDBAction(
        tableName,
        roleArn,
        operation.map(value => value),
        hashKeyField,
        hashKeyValue,
        hashKeyType.map(value => value),
        rangeKeyField.map(value => value),
        rangeKeyValue.map(value => value),
        rangeKeyType.map(value => value),
        payloadField.map(value => value)
      )
    def tableName: TableName
    def roleArn: AwsArn
    def operation: Option[DynamoOperation]
    def hashKeyField: HashKeyField
    def hashKeyValue: HashKeyValue
    def hashKeyType: Option[zio.aws.iot.model.DynamoKeyType]
    def rangeKeyField: Option[RangeKeyField]
    def rangeKeyValue: Option[RangeKeyValue]
    def rangeKeyType: Option[zio.aws.iot.model.DynamoKeyType]
    def payloadField: Option[PayloadField]
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
    def getOperation: ZIO[Any, AwsError, DynamoOperation] =
      AwsError.unwrapOptionField("operation", operation)
    def getHashKeyField: ZIO[Any, Nothing, HashKeyField] =
      ZIO.succeed(hashKeyField)
    def getHashKeyValue: ZIO[Any, Nothing, HashKeyValue] =
      ZIO.succeed(hashKeyValue)
    def getHashKeyType: ZIO[Any, AwsError, zio.aws.iot.model.DynamoKeyType] =
      AwsError.unwrapOptionField("hashKeyType", hashKeyType)
    def getRangeKeyField: ZIO[Any, AwsError, RangeKeyField] =
      AwsError.unwrapOptionField("rangeKeyField", rangeKeyField)
    def getRangeKeyValue: ZIO[Any, AwsError, RangeKeyValue] =
      AwsError.unwrapOptionField("rangeKeyValue", rangeKeyValue)
    def getRangeKeyType: ZIO[Any, AwsError, zio.aws.iot.model.DynamoKeyType] =
      AwsError.unwrapOptionField("rangeKeyType", rangeKeyType)
    def getPayloadField: ZIO[Any, AwsError, PayloadField] =
      AwsError.unwrapOptionField("payloadField", payloadField)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DynamoDBAction
  ) extends zio.aws.iot.model.DynamoDBAction.ReadOnly {
    override val tableName: TableName =
      zio.aws.iot.model.primitives.TableName(impl.tableName())
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
    override val operation: Option[DynamoOperation] = scala
      .Option(impl.operation())
      .map(value => zio.aws.iot.model.primitives.DynamoOperation(value))
    override val hashKeyField: HashKeyField =
      zio.aws.iot.model.primitives.HashKeyField(impl.hashKeyField())
    override val hashKeyValue: HashKeyValue =
      zio.aws.iot.model.primitives.HashKeyValue(impl.hashKeyValue())
    override val hashKeyType: Option[zio.aws.iot.model.DynamoKeyType] = scala
      .Option(impl.hashKeyType())
      .map(value => zio.aws.iot.model.DynamoKeyType.wrap(value))
    override val rangeKeyField: Option[RangeKeyField] = scala
      .Option(impl.rangeKeyField())
      .map(value => zio.aws.iot.model.primitives.RangeKeyField(value))
    override val rangeKeyValue: Option[RangeKeyValue] = scala
      .Option(impl.rangeKeyValue())
      .map(value => zio.aws.iot.model.primitives.RangeKeyValue(value))
    override val rangeKeyType: Option[zio.aws.iot.model.DynamoKeyType] = scala
      .Option(impl.rangeKeyType())
      .map(value => zio.aws.iot.model.DynamoKeyType.wrap(value))
    override val payloadField: Option[PayloadField] = scala
      .Option(impl.payloadField())
      .map(value => zio.aws.iot.model.primitives.PayloadField(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DynamoDBAction
  ): zio.aws.iot.model.DynamoDBAction.ReadOnly = new Wrapper(impl)
}
