package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.FieldName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Field(
    name: Option[FieldName] = None,
    `type`: Option[zio.aws.iot.model.FieldType] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Field = {
    import Field.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Field
      .builder()
      .optionallyWith(
        name.map(value => FieldName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Field.ReadOnly =
    zio.aws.iot.model.Field.wrap(buildAwsValue())
}
object Field {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Field] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Field = zio.aws.iot.model
      .Field(name.map(value => value), `type`.map(value => value))
    def name: Option[FieldName]
    def `type`: Option[zio.aws.iot.model.FieldType]
    def getName: ZIO[Any, AwsError, FieldName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.iot.model.FieldType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Field
  ) extends zio.aws.iot.model.Field.ReadOnly {
    override val name: Option[FieldName] = scala
      .Option(impl.name())
      .map(value => zio.aws.iot.model.primitives.FieldName(value))
    override val `type`: Option[zio.aws.iot.model.FieldType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.iot.model.FieldType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Field
  ): zio.aws.iot.model.Field.ReadOnly = new Wrapper(impl)
}
