package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FileLocation(
    stream: Option[zio.aws.iot.model.Stream] = None,
    s3Location: Option[zio.aws.iot.model.S3Location] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.FileLocation = {
    import FileLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.FileLocation
      .builder()
      .optionallyWith(stream.map(value => value.buildAwsValue()))(_.stream)
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.FileLocation.ReadOnly =
    zio.aws.iot.model.FileLocation.wrap(buildAwsValue())
}
object FileLocation {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.FileLocation] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.FileLocation =
      zio.aws.iot.model.FileLocation(
        stream.map(value => value.asEditable),
        s3Location.map(value => value.asEditable)
      )
    def stream: Option[zio.aws.iot.model.Stream.ReadOnly]
    def s3Location: Option[zio.aws.iot.model.S3Location.ReadOnly]
    def getStream: ZIO[Any, AwsError, zio.aws.iot.model.Stream.ReadOnly] =
      AwsError.unwrapOptionField("stream", stream)
    def getS3Location
        : ZIO[Any, AwsError, zio.aws.iot.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3Location", s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.FileLocation
  ) extends zio.aws.iot.model.FileLocation.ReadOnly {
    override val stream: Option[zio.aws.iot.model.Stream.ReadOnly] = scala
      .Option(impl.stream())
      .map(value => zio.aws.iot.model.Stream.wrap(value))
    override val s3Location: Option[zio.aws.iot.model.S3Location.ReadOnly] =
      scala
        .Option(impl.s3Location())
        .map(value => zio.aws.iot.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.FileLocation
  ): zio.aws.iot.model.FileLocation.ReadOnly = new Wrapper(impl)
}
