package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBehaviorModelTrainingSummariesResponse(
    summaries: Option[
      Iterable[zio.aws.iot.model.BehaviorModelTrainingSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesResponse = {
    import GetBehaviorModelTrainingSummariesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesResponse
      .builder()
      .optionallyWith(
        summaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.GetBehaviorModelTrainingSummariesResponse.ReadOnly =
    zio.aws.iot.model.GetBehaviorModelTrainingSummariesResponse
      .wrap(buildAwsValue())
}
object GetBehaviorModelTrainingSummariesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.GetBehaviorModelTrainingSummariesResponse =
      zio.aws.iot.model.GetBehaviorModelTrainingSummariesResponse(
        summaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaries
        : Option[List[zio.aws.iot.model.BehaviorModelTrainingSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getSummaries: ZIO[Any, AwsError, List[
      zio.aws.iot.model.BehaviorModelTrainingSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaries", summaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesResponse
  ) extends zio.aws.iot.model.GetBehaviorModelTrainingSummariesResponse.ReadOnly {
    override val summaries: Option[
      List[zio.aws.iot.model.BehaviorModelTrainingSummary.ReadOnly]
    ] = scala
      .Option(impl.summaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.BehaviorModelTrainingSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesResponse
  ): zio.aws.iot.model.GetBehaviorModelTrainingSummariesResponse.ReadOnly =
    new Wrapper(impl)
}
