package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AwsArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetLoggingOptionsResponse(
    roleArn: Option[AwsArn] = None,
    logLevel: Option[zio.aws.iot.model.LogLevel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetLoggingOptionsResponse = {
    import GetLoggingOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetLoggingOptionsResponse
      .builder()
      .optionallyWith(
        roleArn.map(value => AwsArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetLoggingOptionsResponse.ReadOnly =
    zio.aws.iot.model.GetLoggingOptionsResponse.wrap(buildAwsValue())
}
object GetLoggingOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetLoggingOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetLoggingOptionsResponse =
      zio.aws.iot.model.GetLoggingOptionsResponse(
        roleArn.map(value => value),
        logLevel.map(value => value)
      )
    def roleArn: Option[AwsArn]
    def logLevel: Option[zio.aws.iot.model.LogLevel]
    def getRoleArn: ZIO[Any, AwsError, AwsArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getLogLevel: ZIO[Any, AwsError, zio.aws.iot.model.LogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetLoggingOptionsResponse
  ) extends zio.aws.iot.model.GetLoggingOptionsResponse.ReadOnly {
    override val roleArn: Option[AwsArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.AwsArn(value))
    override val logLevel: Option[zio.aws.iot.model.LogLevel] = scala
      .Option(impl.logLevel())
      .map(value => zio.aws.iot.model.LogLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetLoggingOptionsResponse
  ): zio.aws.iot.model.GetLoggingOptionsResponse.ReadOnly = new Wrapper(impl)
}
