package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetPercentilesResponse(
    percentiles: Option[Iterable[zio.aws.iot.model.PercentPair]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetPercentilesResponse = {
    import GetPercentilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetPercentilesResponse
      .builder()
      .optionallyWith(
        percentiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.percentiles)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetPercentilesResponse.ReadOnly =
    zio.aws.iot.model.GetPercentilesResponse.wrap(buildAwsValue())
}
object GetPercentilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetPercentilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetPercentilesResponse =
      zio.aws.iot.model.GetPercentilesResponse(
        percentiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def percentiles: Option[List[zio.aws.iot.model.PercentPair.ReadOnly]]
    def getPercentiles
        : ZIO[Any, AwsError, List[zio.aws.iot.model.PercentPair.ReadOnly]] =
      AwsError.unwrapOptionField("percentiles", percentiles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetPercentilesResponse
  ) extends zio.aws.iot.model.GetPercentilesResponse.ReadOnly {
    override val percentiles
        : Option[List[zio.aws.iot.model.PercentPair.ReadOnly]] = scala
      .Option(impl.percentiles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.PercentPair.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetPercentilesResponse
  ): zio.aws.iot.model.GetPercentilesResponse.ReadOnly = new Wrapper(impl)
}
