package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  PolicyArn,
  PolicyName,
  DateType,
  IsDefaultVersion,
  PolicyVersionId,
  PolicyDocument,
  GenerationId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetPolicyVersionResponse(
    policyArn: Option[PolicyArn] = None,
    policyName: Option[PolicyName] = None,
    policyDocument: Option[PolicyDocument] = None,
    policyVersionId: Option[PolicyVersionId] = None,
    isDefaultVersion: Option[IsDefaultVersion] = None,
    creationDate: Option[DateType] = None,
    lastModifiedDate: Option[DateType] = None,
    generationId: Option[GenerationId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetPolicyVersionResponse = {
    import GetPolicyVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetPolicyVersionResponse
      .builder()
      .optionallyWith(
        policyArn.map(value => PolicyArn.unwrap(value): java.lang.String)
      )(_.policyArn)
      .optionallyWith(
        policyName.map(value => PolicyName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyDocument.map(value =>
          PolicyDocument.unwrap(value): java.lang.String
        )
      )(_.policyDocument)
      .optionallyWith(
        policyVersionId.map(value =>
          PolicyVersionId.unwrap(value): java.lang.String
        )
      )(_.policyVersionId)
      .optionallyWith(
        isDefaultVersion.map(value =>
          IsDefaultVersion.unwrap(value): java.lang.Boolean
        )
      )(_.isDefaultVersion)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        generationId.map(value => GenerationId.unwrap(value): java.lang.String)
      )(_.generationId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetPolicyVersionResponse.ReadOnly =
    zio.aws.iot.model.GetPolicyVersionResponse.wrap(buildAwsValue())
}
object GetPolicyVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetPolicyVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetPolicyVersionResponse =
      zio.aws.iot.model.GetPolicyVersionResponse(
        policyArn.map(value => value),
        policyName.map(value => value),
        policyDocument.map(value => value),
        policyVersionId.map(value => value),
        isDefaultVersion.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        generationId.map(value => value)
      )
    def policyArn: Option[PolicyArn]
    def policyName: Option[PolicyName]
    def policyDocument: Option[PolicyDocument]
    def policyVersionId: Option[PolicyVersionId]
    def isDefaultVersion: Option[IsDefaultVersion]
    def creationDate: Option[DateType]
    def lastModifiedDate: Option[DateType]
    def generationId: Option[GenerationId]
    def getPolicyArn: ZIO[Any, AwsError, PolicyArn] =
      AwsError.unwrapOptionField("policyArn", policyArn)
    def getPolicyName: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyDocument: ZIO[Any, AwsError, PolicyDocument] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getPolicyVersionId: ZIO[Any, AwsError, PolicyVersionId] =
      AwsError.unwrapOptionField("policyVersionId", policyVersionId)
    def getIsDefaultVersion: ZIO[Any, AwsError, IsDefaultVersion] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getGenerationId: ZIO[Any, AwsError, GenerationId] =
      AwsError.unwrapOptionField("generationId", generationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetPolicyVersionResponse
  ) extends zio.aws.iot.model.GetPolicyVersionResponse.ReadOnly {
    override val policyArn: Option[PolicyArn] = scala
      .Option(impl.policyArn())
      .map(value => zio.aws.iot.model.primitives.PolicyArn(value))
    override val policyName: Option[PolicyName] = scala
      .Option(impl.policyName())
      .map(value => zio.aws.iot.model.primitives.PolicyName(value))
    override val policyDocument: Option[PolicyDocument] = scala
      .Option(impl.policyDocument())
      .map(value => zio.aws.iot.model.primitives.PolicyDocument(value))
    override val policyVersionId: Option[PolicyVersionId] = scala
      .Option(impl.policyVersionId())
      .map(value => zio.aws.iot.model.primitives.PolicyVersionId(value))
    override val isDefaultVersion: Option[IsDefaultVersion] = scala
      .Option(impl.isDefaultVersion())
      .map(value => zio.aws.iot.model.primitives.IsDefaultVersion(value))
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastModifiedDate: Option[DateType] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val generationId: Option[GenerationId] = scala
      .Option(impl.generationId())
      .map(value => zio.aws.iot.model.primitives.GenerationId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetPolicyVersionResponse
  ): zio.aws.iot.model.GetPolicyVersionResponse.ReadOnly = new Wrapper(impl)
}
