package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.RuleArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetTopicRuleResponse(
    ruleArn: Option[RuleArn] = None,
    rule: Option[zio.aws.iot.model.TopicRule] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetTopicRuleResponse = {
    import GetTopicRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetTopicRuleResponse
      .builder()
      .optionallyWith(
        ruleArn.map(value => RuleArn.unwrap(value): java.lang.String)
      )(_.ruleArn)
      .optionallyWith(rule.map(value => value.buildAwsValue()))(_.rule)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetTopicRuleResponse.ReadOnly =
    zio.aws.iot.model.GetTopicRuleResponse.wrap(buildAwsValue())
}
object GetTopicRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetTopicRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetTopicRuleResponse =
      zio.aws.iot.model.GetTopicRuleResponse(
        ruleArn.map(value => value),
        rule.map(value => value.asEditable)
      )
    def ruleArn: Option[RuleArn]
    def rule: Option[zio.aws.iot.model.TopicRule.ReadOnly]
    def getRuleArn: ZIO[Any, AwsError, RuleArn] =
      AwsError.unwrapOptionField("ruleArn", ruleArn)
    def getRule: ZIO[Any, AwsError, zio.aws.iot.model.TopicRule.ReadOnly] =
      AwsError.unwrapOptionField("rule", rule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetTopicRuleResponse
  ) extends zio.aws.iot.model.GetTopicRuleResponse.ReadOnly {
    override val ruleArn: Option[RuleArn] = scala
      .Option(impl.ruleArn())
      .map(value => zio.aws.iot.model.primitives.RuleArn(value))
    override val rule: Option[zio.aws.iot.model.TopicRule.ReadOnly] = scala
      .Option(impl.rule())
      .map(value => zio.aws.iot.model.TopicRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetTopicRuleResponse
  ): zio.aws.iot.model.GetTopicRuleResponse.ReadOnly = new Wrapper(impl)
}
