package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{DisableAllLogs, AwsArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetV2LoggingOptionsResponse(
    roleArn: Option[AwsArn] = None,
    defaultLogLevel: Option[zio.aws.iot.model.LogLevel] = None,
    disableAllLogs: Option[DisableAllLogs] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsResponse = {
    import GetV2LoggingOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsResponse
      .builder()
      .optionallyWith(
        roleArn.map(value => AwsArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(defaultLogLevel.map(value => value.unwrap))(
        _.defaultLogLevel
      )
      .optionallyWith(
        disableAllLogs.map(value =>
          DisableAllLogs.unwrap(value): java.lang.Boolean
        )
      )(_.disableAllLogs)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetV2LoggingOptionsResponse.ReadOnly =
    zio.aws.iot.model.GetV2LoggingOptionsResponse.wrap(buildAwsValue())
}
object GetV2LoggingOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetV2LoggingOptionsResponse =
      zio.aws.iot.model.GetV2LoggingOptionsResponse(
        roleArn.map(value => value),
        defaultLogLevel.map(value => value),
        disableAllLogs.map(value => value)
      )
    def roleArn: Option[AwsArn]
    def defaultLogLevel: Option[zio.aws.iot.model.LogLevel]
    def disableAllLogs: Option[DisableAllLogs]
    def getRoleArn: ZIO[Any, AwsError, AwsArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getDefaultLogLevel: ZIO[Any, AwsError, zio.aws.iot.model.LogLevel] =
      AwsError.unwrapOptionField("defaultLogLevel", defaultLogLevel)
    def getDisableAllLogs: ZIO[Any, AwsError, DisableAllLogs] =
      AwsError.unwrapOptionField("disableAllLogs", disableAllLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsResponse
  ) extends zio.aws.iot.model.GetV2LoggingOptionsResponse.ReadOnly {
    override val roleArn: Option[AwsArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.AwsArn(value))
    override val defaultLogLevel: Option[zio.aws.iot.model.LogLevel] = scala
      .Option(impl.defaultLogLevel())
      .map(value => zio.aws.iot.model.LogLevel.wrap(value))
    override val disableAllLogs: Option[DisableAllLogs] = scala
      .Option(impl.disableAllLogs())
      .map(value => zio.aws.iot.model.primitives.DisableAllLogs(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsResponse
  ): zio.aws.iot.model.GetV2LoggingOptionsResponse.ReadOnly = new Wrapper(impl)
}
