package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Url
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HttpUrlDestinationProperties(
    confirmationUrl: Option[Url] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.HttpUrlDestinationProperties = {
    import HttpUrlDestinationProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.HttpUrlDestinationProperties
      .builder()
      .optionallyWith(
        confirmationUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.confirmationUrl)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.HttpUrlDestinationProperties.ReadOnly =
    zio.aws.iot.model.HttpUrlDestinationProperties.wrap(buildAwsValue())
}
object HttpUrlDestinationProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.HttpUrlDestinationProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.HttpUrlDestinationProperties =
      zio.aws.iot.model
        .HttpUrlDestinationProperties(confirmationUrl.map(value => value))
    def confirmationUrl: Option[Url]
    def getConfirmationUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("confirmationUrl", confirmationUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.HttpUrlDestinationProperties
  ) extends zio.aws.iot.model.HttpUrlDestinationProperties.ReadOnly {
    override val confirmationUrl: Option[Url] = scala
      .Option(impl.confirmationUrl())
      .map(value => zio.aws.iot.model.primitives.Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.HttpUrlDestinationProperties
  ): zio.aws.iot.model.HttpUrlDestinationProperties.ReadOnly = new Wrapper(impl)
}
