package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{BatchMode, ChannelName, AwsArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IotAnalyticsAction(
    channelArn: Option[AwsArn] = None,
    channelName: Option[ChannelName] = None,
    batchMode: Option[BatchMode] = None,
    roleArn: Option[AwsArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.IotAnalyticsAction = {
    import IotAnalyticsAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.IotAnalyticsAction
      .builder()
      .optionallyWith(
        channelArn.map(value => AwsArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        channelName.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.channelName)
      .optionallyWith(
        batchMode.map(value => BatchMode.unwrap(value): java.lang.Boolean)
      )(_.batchMode)
      .optionallyWith(
        roleArn.map(value => AwsArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.IotAnalyticsAction.ReadOnly =
    zio.aws.iot.model.IotAnalyticsAction.wrap(buildAwsValue())
}
object IotAnalyticsAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.IotAnalyticsAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.IotAnalyticsAction =
      zio.aws.iot.model.IotAnalyticsAction(
        channelArn.map(value => value),
        channelName.map(value => value),
        batchMode.map(value => value),
        roleArn.map(value => value)
      )
    def channelArn: Option[AwsArn]
    def channelName: Option[ChannelName]
    def batchMode: Option[BatchMode]
    def roleArn: Option[AwsArn]
    def getChannelArn: ZIO[Any, AwsError, AwsArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getChannelName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("channelName", channelName)
    def getBatchMode: ZIO[Any, AwsError, BatchMode] =
      AwsError.unwrapOptionField("batchMode", batchMode)
    def getRoleArn: ZIO[Any, AwsError, AwsArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.IotAnalyticsAction
  ) extends zio.aws.iot.model.IotAnalyticsAction.ReadOnly {
    override val channelArn: Option[AwsArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.iot.model.primitives.AwsArn(value))
    override val channelName: Option[ChannelName] = scala
      .Option(impl.channelName())
      .map(value => zio.aws.iot.model.primitives.ChannelName(value))
    override val batchMode: Option[BatchMode] = scala
      .Option(impl.batchMode())
      .map(value => zio.aws.iot.model.primitives.BatchMode(value))
    override val roleArn: Option[AwsArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.AwsArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.IotAnalyticsAction
  ): zio.aws.iot.model.IotAnalyticsAction.ReadOnly = new Wrapper(impl)
}
