package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ParameterKey,
  TargetArn,
  NamespaceId,
  Comment,
  ReasonCode,
  ParameterValue,
  JobTemplateArn,
  JobArn,
  DateType,
  Forced,
  JobId,
  JobDescription
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Job(
    jobArn: Option[JobArn] = None,
    jobId: Option[JobId] = None,
    targetSelection: Option[zio.aws.iot.model.TargetSelection] = None,
    status: Option[zio.aws.iot.model.JobStatus] = None,
    forceCanceled: Option[Forced] = None,
    reasonCode: Option[ReasonCode] = None,
    comment: Option[Comment] = None,
    targets: Option[Iterable[TargetArn]] = None,
    description: Option[JobDescription] = None,
    presignedUrlConfig: Option[zio.aws.iot.model.PresignedUrlConfig] = None,
    jobExecutionsRolloutConfig: Option[
      zio.aws.iot.model.JobExecutionsRolloutConfig
    ] = None,
    abortConfig: Option[zio.aws.iot.model.AbortConfig] = None,
    createdAt: Option[DateType] = None,
    lastUpdatedAt: Option[DateType] = None,
    completedAt: Option[DateType] = None,
    jobProcessDetails: Option[zio.aws.iot.model.JobProcessDetails] = None,
    timeoutConfig: Option[zio.aws.iot.model.TimeoutConfig] = None,
    namespaceId: Option[NamespaceId] = None,
    jobTemplateArn: Option[JobTemplateArn] = None,
    jobExecutionsRetryConfig: Option[
      zio.aws.iot.model.JobExecutionsRetryConfig
    ] = None,
    documentParameters: Option[Map[ParameterKey, ParameterValue]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Job = {
    import Job.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Job
      .builder()
      .optionallyWith(
        jobArn.map(value => JobArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(targetSelection.map(value => value.unwrap))(
        _.targetSelection
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        forceCanceled.map(value => Forced.unwrap(value): java.lang.Boolean)
      )(_.forceCanceled)
      .optionallyWith(
        reasonCode.map(value => ReasonCode.unwrap(value): java.lang.String)
      )(_.reasonCode)
      .optionallyWith(
        comment.map(value => Comment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            TargetArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(presignedUrlConfig.map(value => value.buildAwsValue()))(
        _.presignedUrlConfig
      )
      .optionallyWith(
        jobExecutionsRolloutConfig.map(value => value.buildAwsValue())
      )(_.jobExecutionsRolloutConfig)
      .optionallyWith(abortConfig.map(value => value.buildAwsValue()))(
        _.abortConfig
      )
      .optionallyWith(createdAt.map(value => DateType.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => DateType.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        completedAt.map(value => DateType.unwrap(value): Instant)
      )(_.completedAt)
      .optionallyWith(jobProcessDetails.map(value => value.buildAwsValue()))(
        _.jobProcessDetails
      )
      .optionallyWith(timeoutConfig.map(value => value.buildAwsValue()))(
        _.timeoutConfig
      )
      .optionallyWith(
        namespaceId.map(value => NamespaceId.unwrap(value): java.lang.String)
      )(_.namespaceId)
      .optionallyWith(
        jobTemplateArn.map(value =>
          JobTemplateArn.unwrap(value): java.lang.String
        )
      )(_.jobTemplateArn)
      .optionallyWith(
        jobExecutionsRetryConfig.map(value => value.buildAwsValue())
      )(_.jobExecutionsRetryConfig)
      .optionallyWith(
        documentParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterKey.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.documentParameters)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Job.ReadOnly =
    zio.aws.iot.model.Job.wrap(buildAwsValue())
}
object Job {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Job] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Job = zio.aws.iot.model.Job(
      jobArn.map(value => value),
      jobId.map(value => value),
      targetSelection.map(value => value),
      status.map(value => value),
      forceCanceled.map(value => value),
      reasonCode.map(value => value),
      comment.map(value => value),
      targets.map(value => value),
      description.map(value => value),
      presignedUrlConfig.map(value => value.asEditable),
      jobExecutionsRolloutConfig.map(value => value.asEditable),
      abortConfig.map(value => value.asEditable),
      createdAt.map(value => value),
      lastUpdatedAt.map(value => value),
      completedAt.map(value => value),
      jobProcessDetails.map(value => value.asEditable),
      timeoutConfig.map(value => value.asEditable),
      namespaceId.map(value => value),
      jobTemplateArn.map(value => value),
      jobExecutionsRetryConfig.map(value => value.asEditable),
      documentParameters.map(value => value)
    )
    def jobArn: Option[JobArn]
    def jobId: Option[JobId]
    def targetSelection: Option[zio.aws.iot.model.TargetSelection]
    def status: Option[zio.aws.iot.model.JobStatus]
    def forceCanceled: Option[Forced]
    def reasonCode: Option[ReasonCode]
    def comment: Option[Comment]
    def targets: Option[List[TargetArn]]
    def description: Option[JobDescription]
    def presignedUrlConfig
        : Option[zio.aws.iot.model.PresignedUrlConfig.ReadOnly]
    def jobExecutionsRolloutConfig
        : Option[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly]
    def abortConfig: Option[zio.aws.iot.model.AbortConfig.ReadOnly]
    def createdAt: Option[DateType]
    def lastUpdatedAt: Option[DateType]
    def completedAt: Option[DateType]
    def jobProcessDetails: Option[zio.aws.iot.model.JobProcessDetails.ReadOnly]
    def timeoutConfig: Option[zio.aws.iot.model.TimeoutConfig.ReadOnly]
    def namespaceId: Option[NamespaceId]
    def jobTemplateArn: Option[JobTemplateArn]
    def jobExecutionsRetryConfig
        : Option[zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly]
    def documentParameters: Option[Map[ParameterKey, ParameterValue]]
    def getJobArn: ZIO[Any, AwsError, JobArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getTargetSelection
        : ZIO[Any, AwsError, zio.aws.iot.model.TargetSelection] =
      AwsError.unwrapOptionField("targetSelection", targetSelection)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getForceCanceled: ZIO[Any, AwsError, Forced] =
      AwsError.unwrapOptionField("forceCanceled", forceCanceled)
    def getReasonCode: ZIO[Any, AwsError, ReasonCode] =
      AwsError.unwrapOptionField("reasonCode", reasonCode)
    def getComment: ZIO[Any, AwsError, Comment] =
      AwsError.unwrapOptionField("comment", comment)
    def getTargets: ZIO[Any, AwsError, List[TargetArn]] =
      AwsError.unwrapOptionField("targets", targets)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPresignedUrlConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.PresignedUrlConfig.ReadOnly] =
      AwsError.unwrapOptionField("presignedUrlConfig", presignedUrlConfig)
    def getJobExecutionsRolloutConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobExecutionsRolloutConfig",
      jobExecutionsRolloutConfig
    )
    def getAbortConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AbortConfig.ReadOnly] =
      AwsError.unwrapOptionField("abortConfig", abortConfig)
    def getCreatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getCompletedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("completedAt", completedAt)
    def getJobProcessDetails
        : ZIO[Any, AwsError, zio.aws.iot.model.JobProcessDetails.ReadOnly] =
      AwsError.unwrapOptionField("jobProcessDetails", jobProcessDetails)
    def getTimeoutConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.TimeoutConfig.ReadOnly] =
      AwsError.unwrapOptionField("timeoutConfig", timeoutConfig)
    def getNamespaceId: ZIO[Any, AwsError, NamespaceId] =
      AwsError.unwrapOptionField("namespaceId", namespaceId)
    def getJobTemplateArn: ZIO[Any, AwsError, JobTemplateArn] =
      AwsError.unwrapOptionField("jobTemplateArn", jobTemplateArn)
    def getJobExecutionsRetryConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobExecutionsRetryConfig",
      jobExecutionsRetryConfig
    )
    def getDocumentParameters
        : ZIO[Any, AwsError, Map[ParameterKey, ParameterValue]] =
      AwsError.unwrapOptionField("documentParameters", documentParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Job
  ) extends zio.aws.iot.model.Job.ReadOnly {
    override val jobArn: Option[JobArn] = scala
      .Option(impl.jobArn())
      .map(value => zio.aws.iot.model.primitives.JobArn(value))
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.iot.model.primitives.JobId(value))
    override val targetSelection: Option[zio.aws.iot.model.TargetSelection] =
      scala
        .Option(impl.targetSelection())
        .map(value => zio.aws.iot.model.TargetSelection.wrap(value))
    override val status: Option[zio.aws.iot.model.JobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.JobStatus.wrap(value))
    override val forceCanceled: Option[Forced] = scala
      .Option(impl.forceCanceled())
      .map(value => zio.aws.iot.model.primitives.Forced(value))
    override val reasonCode: Option[ReasonCode] = scala
      .Option(impl.reasonCode())
      .map(value => zio.aws.iot.model.primitives.ReasonCode(value))
    override val comment: Option[Comment] = scala
      .Option(impl.comment())
      .map(value => zio.aws.iot.model.primitives.Comment(value))
    override val targets: Option[List[TargetArn]] = scala
      .Option(impl.targets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.TargetArn(item)
        }.toList
      )
    override val description: Option[JobDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.JobDescription(value))
    override val presignedUrlConfig
        : Option[zio.aws.iot.model.PresignedUrlConfig.ReadOnly] = scala
      .Option(impl.presignedUrlConfig())
      .map(value => zio.aws.iot.model.PresignedUrlConfig.wrap(value))
    override val jobExecutionsRolloutConfig
        : Option[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly] = scala
      .Option(impl.jobExecutionsRolloutConfig())
      .map(value => zio.aws.iot.model.JobExecutionsRolloutConfig.wrap(value))
    override val abortConfig: Option[zio.aws.iot.model.AbortConfig.ReadOnly] =
      scala
        .Option(impl.abortConfig())
        .map(value => zio.aws.iot.model.AbortConfig.wrap(value))
    override val createdAt: Option[DateType] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastUpdatedAt: Option[DateType] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val completedAt: Option[DateType] = scala
      .Option(impl.completedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val jobProcessDetails
        : Option[zio.aws.iot.model.JobProcessDetails.ReadOnly] = scala
      .Option(impl.jobProcessDetails())
      .map(value => zio.aws.iot.model.JobProcessDetails.wrap(value))
    override val timeoutConfig
        : Option[zio.aws.iot.model.TimeoutConfig.ReadOnly] = scala
      .Option(impl.timeoutConfig())
      .map(value => zio.aws.iot.model.TimeoutConfig.wrap(value))
    override val namespaceId: Option[NamespaceId] = scala
      .Option(impl.namespaceId())
      .map(value => zio.aws.iot.model.primitives.NamespaceId(value))
    override val jobTemplateArn: Option[JobTemplateArn] = scala
      .Option(impl.jobTemplateArn())
      .map(value => zio.aws.iot.model.primitives.JobTemplateArn(value))
    override val jobExecutionsRetryConfig
        : Option[zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly] = scala
      .Option(impl.jobExecutionsRetryConfig())
      .map(value => zio.aws.iot.model.JobExecutionsRetryConfig.wrap(value))
    override val documentParameters: Option[Map[ParameterKey, ParameterValue]] =
      scala
        .Option(impl.documentParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iot.model.primitives.ParameterKey(
                key
              ) -> zio.aws.iot.model.primitives.ParameterValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Job
  ): zio.aws.iot.model.Job.ReadOnly = new Wrapper(impl)
}
