package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{DetailsValue, DetailsKey}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class JobExecutionStatusDetails(
    detailsMap: Option[Map[DetailsKey, DetailsValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.JobExecutionStatusDetails = {
    import JobExecutionStatusDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.JobExecutionStatusDetails
      .builder()
      .optionallyWith(
        detailsMap.map(value =>
          value
            .map({ case (key, value) =>
              (DetailsKey.unwrap(key): java.lang.String) -> (DetailsValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.detailsMap)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.JobExecutionStatusDetails.ReadOnly =
    zio.aws.iot.model.JobExecutionStatusDetails.wrap(buildAwsValue())
}
object JobExecutionStatusDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.JobExecutionStatusDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.JobExecutionStatusDetails =
      zio.aws.iot.model
        .JobExecutionStatusDetails(detailsMap.map(value => value))
    def detailsMap: Option[Map[DetailsKey, DetailsValue]]
    def getDetailsMap: ZIO[Any, AwsError, Map[DetailsKey, DetailsValue]] =
      AwsError.unwrapOptionField("detailsMap", detailsMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.JobExecutionStatusDetails
  ) extends zio.aws.iot.model.JobExecutionStatusDetails.ReadOnly {
    override val detailsMap: Option[Map[DetailsKey, DetailsValue]] = scala
      .Option(impl.detailsMap())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives.DetailsKey(
              key
            ) -> zio.aws.iot.model.primitives.DetailsValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.JobExecutionStatusDetails
  ): zio.aws.iot.model.JobExecutionStatusDetails.ReadOnly = new Wrapper(impl)
}
