package zio.aws.iot.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{RetryAttempt, ExecutionNumber, DateType}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class JobExecutionSummary(
    status: Option[zio.aws.iot.model.JobExecutionStatus] = None,
    queuedAt: Option[DateType] = None,
    startedAt: Option[DateType] = None,
    lastUpdatedAt: Option[DateType] = None,
    executionNumber: Option[ExecutionNumber] = None,
    retryAttempt: Option[RetryAttempt] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.JobExecutionSummary = {
    import JobExecutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.JobExecutionSummary
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(queuedAt.map(value => DateType.unwrap(value): Instant))(
        _.queuedAt
      )
      .optionallyWith(startedAt.map(value => DateType.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => DateType.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        executionNumber.map(value =>
          ExecutionNumber.unwrap(value): java.lang.Long
        )
      )(_.executionNumber)
      .optionallyWith(
        retryAttempt.map(value => RetryAttempt.unwrap(value): Integer)
      )(_.retryAttempt)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.JobExecutionSummary.ReadOnly =
    zio.aws.iot.model.JobExecutionSummary.wrap(buildAwsValue())
}
object JobExecutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.JobExecutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.JobExecutionSummary =
      zio.aws.iot.model.JobExecutionSummary(
        status.map(value => value),
        queuedAt.map(value => value),
        startedAt.map(value => value),
        lastUpdatedAt.map(value => value),
        executionNumber.map(value => value),
        retryAttempt.map(value => value)
      )
    def status: Option[zio.aws.iot.model.JobExecutionStatus]
    def queuedAt: Option[DateType]
    def startedAt: Option[DateType]
    def lastUpdatedAt: Option[DateType]
    def executionNumber: Option[ExecutionNumber]
    def retryAttempt: Option[RetryAttempt]
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.JobExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getQueuedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("queuedAt", queuedAt)
    def getStartedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getExecutionNumber: ZIO[Any, AwsError, ExecutionNumber] =
      AwsError.unwrapOptionField("executionNumber", executionNumber)
    def getRetryAttempt: ZIO[Any, AwsError, RetryAttempt] =
      AwsError.unwrapOptionField("retryAttempt", retryAttempt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.JobExecutionSummary
  ) extends zio.aws.iot.model.JobExecutionSummary.ReadOnly {
    override val status: Option[zio.aws.iot.model.JobExecutionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.JobExecutionStatus.wrap(value))
    override val queuedAt: Option[DateType] = scala
      .Option(impl.queuedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val startedAt: Option[DateType] = scala
      .Option(impl.startedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastUpdatedAt: Option[DateType] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val executionNumber: Option[ExecutionNumber] = scala
      .Option(impl.executionNumber())
      .map(value => zio.aws.iot.model.primitives.ExecutionNumber(value))
    override val retryAttempt: Option[RetryAttempt] = scala
      .Option(impl.retryAttempt())
      .map(value => zio.aws.iot.model.primitives.RetryAttempt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.JobExecutionSummary
  ): zio.aws.iot.model.JobExecutionSummary.ReadOnly = new Wrapper(impl)
}
