package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  RemovedThings,
  RejectedThings,
  ProcessingTargetName,
  QueuedThings,
  CanceledThings,
  InProgressThings,
  TimedOutThings,
  FailedThings,
  SucceededThings
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class JobProcessDetails(
    processingTargets: Option[Iterable[ProcessingTargetName]] = None,
    numberOfCanceledThings: Option[CanceledThings] = None,
    numberOfSucceededThings: Option[SucceededThings] = None,
    numberOfFailedThings: Option[FailedThings] = None,
    numberOfRejectedThings: Option[RejectedThings] = None,
    numberOfQueuedThings: Option[QueuedThings] = None,
    numberOfInProgressThings: Option[InProgressThings] = None,
    numberOfRemovedThings: Option[RemovedThings] = None,
    numberOfTimedOutThings: Option[TimedOutThings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.JobProcessDetails = {
    import JobProcessDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.JobProcessDetails
      .builder()
      .optionallyWith(
        processingTargets.map(value =>
          value.map { item =>
            ProcessingTargetName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.processingTargets)
      .optionallyWith(
        numberOfCanceledThings.map(value =>
          CanceledThings.unwrap(value): Integer
        )
      )(_.numberOfCanceledThings)
      .optionallyWith(
        numberOfSucceededThings.map(value =>
          SucceededThings.unwrap(value): Integer
        )
      )(_.numberOfSucceededThings)
      .optionallyWith(
        numberOfFailedThings.map(value => FailedThings.unwrap(value): Integer)
      )(_.numberOfFailedThings)
      .optionallyWith(
        numberOfRejectedThings.map(value =>
          RejectedThings.unwrap(value): Integer
        )
      )(_.numberOfRejectedThings)
      .optionallyWith(
        numberOfQueuedThings.map(value => QueuedThings.unwrap(value): Integer)
      )(_.numberOfQueuedThings)
      .optionallyWith(
        numberOfInProgressThings.map(value =>
          InProgressThings.unwrap(value): Integer
        )
      )(_.numberOfInProgressThings)
      .optionallyWith(
        numberOfRemovedThings.map(value => RemovedThings.unwrap(value): Integer)
      )(_.numberOfRemovedThings)
      .optionallyWith(
        numberOfTimedOutThings.map(value =>
          TimedOutThings.unwrap(value): Integer
        )
      )(_.numberOfTimedOutThings)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.JobProcessDetails.ReadOnly =
    zio.aws.iot.model.JobProcessDetails.wrap(buildAwsValue())
}
object JobProcessDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.JobProcessDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.JobProcessDetails =
      zio.aws.iot.model.JobProcessDetails(
        processingTargets.map(value => value),
        numberOfCanceledThings.map(value => value),
        numberOfSucceededThings.map(value => value),
        numberOfFailedThings.map(value => value),
        numberOfRejectedThings.map(value => value),
        numberOfQueuedThings.map(value => value),
        numberOfInProgressThings.map(value => value),
        numberOfRemovedThings.map(value => value),
        numberOfTimedOutThings.map(value => value)
      )
    def processingTargets: Option[List[ProcessingTargetName]]
    def numberOfCanceledThings: Option[CanceledThings]
    def numberOfSucceededThings: Option[SucceededThings]
    def numberOfFailedThings: Option[FailedThings]
    def numberOfRejectedThings: Option[RejectedThings]
    def numberOfQueuedThings: Option[QueuedThings]
    def numberOfInProgressThings: Option[InProgressThings]
    def numberOfRemovedThings: Option[RemovedThings]
    def numberOfTimedOutThings: Option[TimedOutThings]
    def getProcessingTargets: ZIO[Any, AwsError, List[ProcessingTargetName]] =
      AwsError.unwrapOptionField("processingTargets", processingTargets)
    def getNumberOfCanceledThings: ZIO[Any, AwsError, CanceledThings] = AwsError
      .unwrapOptionField("numberOfCanceledThings", numberOfCanceledThings)
    def getNumberOfSucceededThings: ZIO[Any, AwsError, SucceededThings] =
      AwsError.unwrapOptionField(
        "numberOfSucceededThings",
        numberOfSucceededThings
      )
    def getNumberOfFailedThings: ZIO[Any, AwsError, FailedThings] =
      AwsError.unwrapOptionField("numberOfFailedThings", numberOfFailedThings)
    def getNumberOfRejectedThings: ZIO[Any, AwsError, RejectedThings] = AwsError
      .unwrapOptionField("numberOfRejectedThings", numberOfRejectedThings)
    def getNumberOfQueuedThings: ZIO[Any, AwsError, QueuedThings] =
      AwsError.unwrapOptionField("numberOfQueuedThings", numberOfQueuedThings)
    def getNumberOfInProgressThings: ZIO[Any, AwsError, InProgressThings] =
      AwsError.unwrapOptionField(
        "numberOfInProgressThings",
        numberOfInProgressThings
      )
    def getNumberOfRemovedThings: ZIO[Any, AwsError, RemovedThings] =
      AwsError.unwrapOptionField("numberOfRemovedThings", numberOfRemovedThings)
    def getNumberOfTimedOutThings: ZIO[Any, AwsError, TimedOutThings] = AwsError
      .unwrapOptionField("numberOfTimedOutThings", numberOfTimedOutThings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.JobProcessDetails
  ) extends zio.aws.iot.model.JobProcessDetails.ReadOnly {
    override val processingTargets: Option[List[ProcessingTargetName]] = scala
      .Option(impl.processingTargets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.ProcessingTargetName(item)
        }.toList
      )
    override val numberOfCanceledThings: Option[CanceledThings] = scala
      .Option(impl.numberOfCanceledThings())
      .map(value => zio.aws.iot.model.primitives.CanceledThings(value))
    override val numberOfSucceededThings: Option[SucceededThings] = scala
      .Option(impl.numberOfSucceededThings())
      .map(value => zio.aws.iot.model.primitives.SucceededThings(value))
    override val numberOfFailedThings: Option[FailedThings] = scala
      .Option(impl.numberOfFailedThings())
      .map(value => zio.aws.iot.model.primitives.FailedThings(value))
    override val numberOfRejectedThings: Option[RejectedThings] = scala
      .Option(impl.numberOfRejectedThings())
      .map(value => zio.aws.iot.model.primitives.RejectedThings(value))
    override val numberOfQueuedThings: Option[QueuedThings] = scala
      .Option(impl.numberOfQueuedThings())
      .map(value => zio.aws.iot.model.primitives.QueuedThings(value))
    override val numberOfInProgressThings: Option[InProgressThings] = scala
      .Option(impl.numberOfInProgressThings())
      .map(value => zio.aws.iot.model.primitives.InProgressThings(value))
    override val numberOfRemovedThings: Option[RemovedThings] = scala
      .Option(impl.numberOfRemovedThings())
      .map(value => zio.aws.iot.model.primitives.RemovedThings(value))
    override val numberOfTimedOutThings: Option[TimedOutThings] = scala
      .Option(impl.numberOfTimedOutThings())
      .map(value => zio.aws.iot.model.primitives.TimedOutThings(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.JobProcessDetails
  ): zio.aws.iot.model.JobProcessDetails.ReadOnly = new Wrapper(impl)
}
