package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{DateType, ThingGroupId, JobId, JobArn}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class JobSummary(
    jobArn: Option[JobArn] = None,
    jobId: Option[JobId] = None,
    thingGroupId: Option[ThingGroupId] = None,
    targetSelection: Option[zio.aws.iot.model.TargetSelection] = None,
    status: Option[zio.aws.iot.model.JobStatus] = None,
    createdAt: Option[DateType] = None,
    lastUpdatedAt: Option[DateType] = None,
    completedAt: Option[DateType] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.JobSummary = {
    import JobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.JobSummary
      .builder()
      .optionallyWith(
        jobArn.map(value => JobArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        thingGroupId.map(value => ThingGroupId.unwrap(value): java.lang.String)
      )(_.thingGroupId)
      .optionallyWith(targetSelection.map(value => value.unwrap))(
        _.targetSelection
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => DateType.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => DateType.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        completedAt.map(value => DateType.unwrap(value): Instant)
      )(_.completedAt)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.JobSummary.ReadOnly =
    zio.aws.iot.model.JobSummary.wrap(buildAwsValue())
}
object JobSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.JobSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.JobSummary = zio.aws.iot.model.JobSummary(
      jobArn.map(value => value),
      jobId.map(value => value),
      thingGroupId.map(value => value),
      targetSelection.map(value => value),
      status.map(value => value),
      createdAt.map(value => value),
      lastUpdatedAt.map(value => value),
      completedAt.map(value => value)
    )
    def jobArn: Option[JobArn]
    def jobId: Option[JobId]
    def thingGroupId: Option[ThingGroupId]
    def targetSelection: Option[zio.aws.iot.model.TargetSelection]
    def status: Option[zio.aws.iot.model.JobStatus]
    def createdAt: Option[DateType]
    def lastUpdatedAt: Option[DateType]
    def completedAt: Option[DateType]
    def getJobArn: ZIO[Any, AwsError, JobArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getThingGroupId: ZIO[Any, AwsError, ThingGroupId] =
      AwsError.unwrapOptionField("thingGroupId", thingGroupId)
    def getTargetSelection
        : ZIO[Any, AwsError, zio.aws.iot.model.TargetSelection] =
      AwsError.unwrapOptionField("targetSelection", targetSelection)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getCompletedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("completedAt", completedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.JobSummary
  ) extends zio.aws.iot.model.JobSummary.ReadOnly {
    override val jobArn: Option[JobArn] = scala
      .Option(impl.jobArn())
      .map(value => zio.aws.iot.model.primitives.JobArn(value))
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.iot.model.primitives.JobId(value))
    override val thingGroupId: Option[ThingGroupId] = scala
      .Option(impl.thingGroupId())
      .map(value => zio.aws.iot.model.primitives.ThingGroupId(value))
    override val targetSelection: Option[zio.aws.iot.model.TargetSelection] =
      scala
        .Option(impl.targetSelection())
        .map(value => zio.aws.iot.model.TargetSelection.wrap(value))
    override val status: Option[zio.aws.iot.model.JobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.JobStatus.wrap(value))
    override val createdAt: Option[DateType] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastUpdatedAt: Option[DateType] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val completedAt: Option[DateType] = scala
      .Option(impl.completedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.JobSummary
  ): zio.aws.iot.model.JobSummary.ReadOnly = new Wrapper(impl)
}
