package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{PageSize, Marker, Recursive, PolicyTarget}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAttachedPoliciesRequest(
    target: PolicyTarget,
    recursive: Option[Recursive] = None,
    marker: Option[Marker] = None,
    pageSize: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest = {
    import ListAttachedPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest
      .builder()
      .target(PolicyTarget.unwrap(target): java.lang.String)
      .optionallyWith(
        recursive.map(value => Recursive.unwrap(value): java.lang.Boolean)
      )(_.recursive)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListAttachedPoliciesRequest.ReadOnly =
    zio.aws.iot.model.ListAttachedPoliciesRequest.wrap(buildAwsValue())
}
object ListAttachedPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListAttachedPoliciesRequest =
      zio.aws.iot.model.ListAttachedPoliciesRequest(
        target,
        recursive.map(value => value),
        marker.map(value => value),
        pageSize.map(value => value)
      )
    def target: PolicyTarget
    def recursive: Option[Recursive]
    def marker: Option[Marker]
    def pageSize: Option[PageSize]
    def getTarget: ZIO[Any, Nothing, PolicyTarget] = ZIO.succeed(target)
    def getRecursive: ZIO[Any, AwsError, Recursive] =
      AwsError.unwrapOptionField("recursive", recursive)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest
  ) extends zio.aws.iot.model.ListAttachedPoliciesRequest.ReadOnly {
    override val target: PolicyTarget =
      zio.aws.iot.model.primitives.PolicyTarget(impl.target())
    override val recursive: Option[Recursive] = scala
      .Option(impl.recursive())
      .map(value => zio.aws.iot.model.primitives.Recursive(value))
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.iot.model.primitives.PageSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest
  ): zio.aws.iot.model.ListAttachedPoliciesRequest.ReadOnly = new Wrapper(impl)
}
