package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAuditFindingsResponse(
    findings: Option[Iterable[zio.aws.iot.model.AuditFinding]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListAuditFindingsResponse = {
    import ListAuditFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListAuditFindingsResponse
      .builder()
      .optionallyWith(
        findings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findings)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListAuditFindingsResponse.ReadOnly =
    zio.aws.iot.model.ListAuditFindingsResponse.wrap(buildAwsValue())
}
object ListAuditFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListAuditFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListAuditFindingsResponse =
      zio.aws.iot.model.ListAuditFindingsResponse(
        findings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def findings: Option[List[zio.aws.iot.model.AuditFinding.ReadOnly]]
    def nextToken: Option[NextToken]
    def getFindings
        : ZIO[Any, AwsError, List[zio.aws.iot.model.AuditFinding.ReadOnly]] =
      AwsError.unwrapOptionField("findings", findings)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListAuditFindingsResponse
  ) extends zio.aws.iot.model.ListAuditFindingsResponse.ReadOnly {
    override val findings
        : Option[List[zio.aws.iot.model.AuditFinding.ReadOnly]] = scala
      .Option(impl.findings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.AuditFinding.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListAuditFindingsResponse
  ): zio.aws.iot.model.ListAuditFindingsResponse.ReadOnly = new Wrapper(impl)
}
