package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAuditSuppressionsResponse(
    suppressions: Option[Iterable[zio.aws.iot.model.AuditSuppression]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse = {
    import ListAuditSuppressionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse
      .builder()
      .optionallyWith(
        suppressions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.suppressions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListAuditSuppressionsResponse.ReadOnly =
    zio.aws.iot.model.ListAuditSuppressionsResponse.wrap(buildAwsValue())
}
object ListAuditSuppressionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListAuditSuppressionsResponse =
      zio.aws.iot.model.ListAuditSuppressionsResponse(
        suppressions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def suppressions: Option[List[zio.aws.iot.model.AuditSuppression.ReadOnly]]
    def nextToken: Option[NextToken]
    def getSuppressions: ZIO[Any, AwsError, List[
      zio.aws.iot.model.AuditSuppression.ReadOnly
    ]] = AwsError.unwrapOptionField("suppressions", suppressions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse
  ) extends zio.aws.iot.model.ListAuditSuppressionsResponse.ReadOnly {
    override val suppressions
        : Option[List[zio.aws.iot.model.AuditSuppression.ReadOnly]] = scala
      .Option(impl.suppressions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.AuditSuppression.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse
  ): zio.aws.iot.model.ListAuditSuppressionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
