package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAuditTasksResponse(
    tasks: Option[Iterable[zio.aws.iot.model.AuditTaskMetadata]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListAuditTasksResponse = {
    import ListAuditTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListAuditTasksResponse
      .builder()
      .optionallyWith(
        tasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tasks)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListAuditTasksResponse.ReadOnly =
    zio.aws.iot.model.ListAuditTasksResponse.wrap(buildAwsValue())
}
object ListAuditTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListAuditTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListAuditTasksResponse =
      zio.aws.iot.model.ListAuditTasksResponse(
        tasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def tasks: Option[List[zio.aws.iot.model.AuditTaskMetadata.ReadOnly]]
    def nextToken: Option[NextToken]
    def getTasks: ZIO[Any, AwsError, List[
      zio.aws.iot.model.AuditTaskMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("tasks", tasks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListAuditTasksResponse
  ) extends zio.aws.iot.model.ListAuditTasksResponse.ReadOnly {
    override val tasks
        : Option[List[zio.aws.iot.model.AuditTaskMetadata.ReadOnly]] = scala
      .Option(impl.tasks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.AuditTaskMetadata.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListAuditTasksResponse
  ): zio.aws.iot.model.ListAuditTasksResponse.ReadOnly = new Wrapper(impl)
}
