package zio.aws.iot.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  DeviceDefenderThingName,
  NextToken,
  ViolationId,
  Timestamp,
  MaxResults,
  MitigationActionsTaskId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDetectMitigationActionsExecutionsRequest(
    taskId: Option[MitigationActionsTaskId] = None,
    violationId: Option[ViolationId] = None,
    thingName: Option[DeviceDefenderThingName] = None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest = {
    import ListDetectMitigationActionsExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest
      .builder()
      .optionallyWith(
        taskId.map(value =>
          MitigationActionsTaskId.unwrap(value): java.lang.String
        )
      )(_.taskId)
      .optionallyWith(
        violationId.map(value => ViolationId.unwrap(value): java.lang.String)
      )(_.violationId)
      .optionallyWith(
        thingName.map(value =>
          DeviceDefenderThingName.unwrap(value): java.lang.String
        )
      )(_.thingName)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListDetectMitigationActionsExecutionsRequest.ReadOnly =
    zio.aws.iot.model.ListDetectMitigationActionsExecutionsRequest
      .wrap(buildAwsValue())
}
object ListDetectMitigationActionsExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.ListDetectMitigationActionsExecutionsRequest =
      zio.aws.iot.model.ListDetectMitigationActionsExecutionsRequest(
        taskId.map(value => value),
        violationId.map(value => value),
        thingName.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def taskId: Option[MitigationActionsTaskId]
    def violationId: Option[ViolationId]
    def thingName: Option[DeviceDefenderThingName]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getTaskId: ZIO[Any, AwsError, MitigationActionsTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getViolationId: ZIO[Any, AwsError, ViolationId] =
      AwsError.unwrapOptionField("violationId", violationId)
    def getThingName: ZIO[Any, AwsError, DeviceDefenderThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest
  ) extends zio.aws.iot.model.ListDetectMitigationActionsExecutionsRequest.ReadOnly {
    override val taskId: Option[MitigationActionsTaskId] = scala
      .Option(impl.taskId())
      .map(value => zio.aws.iot.model.primitives.MitigationActionsTaskId(value))
    override val violationId: Option[ViolationId] = scala
      .Option(impl.violationId())
      .map(value => zio.aws.iot.model.primitives.ViolationId(value))
    override val thingName: Option[DeviceDefenderThingName] = scala
      .Option(impl.thingName())
      .map(value => zio.aws.iot.model.primitives.DeviceDefenderThingName(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest
  ): zio.aws.iot.model.ListDetectMitigationActionsExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
