package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{NextToken, DimensionName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDimensionsResponse(
    dimensionNames: Option[Iterable[DimensionName]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListDimensionsResponse = {
    import ListDimensionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListDimensionsResponse
      .builder()
      .optionallyWith(
        dimensionNames.map(value =>
          value.map { item =>
            DimensionName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dimensionNames)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListDimensionsResponse.ReadOnly =
    zio.aws.iot.model.ListDimensionsResponse.wrap(buildAwsValue())
}
object ListDimensionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListDimensionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListDimensionsResponse =
      zio.aws.iot.model.ListDimensionsResponse(
        dimensionNames.map(value => value),
        nextToken.map(value => value)
      )
    def dimensionNames: Option[List[DimensionName]]
    def nextToken: Option[NextToken]
    def getDimensionNames: ZIO[Any, AwsError, List[DimensionName]] =
      AwsError.unwrapOptionField("dimensionNames", dimensionNames)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListDimensionsResponse
  ) extends zio.aws.iot.model.ListDimensionsResponse.ReadOnly {
    override val dimensionNames: Option[List[DimensionName]] = scala
      .Option(impl.dimensionNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.DimensionName(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListDimensionsResponse
  ): zio.aws.iot.model.ListDimensionsResponse.ReadOnly = new Wrapper(impl)
}
