package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Marker
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDomainConfigurationsResponse(
    domainConfigurations: Option[
      Iterable[zio.aws.iot.model.DomainConfigurationSummary]
    ] = None,
    nextMarker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListDomainConfigurationsResponse = {
    import ListDomainConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListDomainConfigurationsResponse
      .builder()
      .optionallyWith(
        domainConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainConfigurations)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListDomainConfigurationsResponse.ReadOnly =
    zio.aws.iot.model.ListDomainConfigurationsResponse.wrap(buildAwsValue())
}
object ListDomainConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListDomainConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListDomainConfigurationsResponse =
      zio.aws.iot.model.ListDomainConfigurationsResponse(
        domainConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def domainConfigurations
        : Option[List[zio.aws.iot.model.DomainConfigurationSummary.ReadOnly]]
    def nextMarker: Option[Marker]
    def getDomainConfigurations: ZIO[Any, AwsError, List[
      zio.aws.iot.model.DomainConfigurationSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("domainConfigurations", domainConfigurations)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListDomainConfigurationsResponse
  ) extends zio.aws.iot.model.ListDomainConfigurationsResponse.ReadOnly {
    override val domainConfigurations
        : Option[List[zio.aws.iot.model.DomainConfigurationSummary.ReadOnly]] =
      scala
        .Option(impl.domainConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.DomainConfigurationSummary.wrap(item)
          }.toList
        )
    override val nextMarker: Option[Marker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListDomainConfigurationsResponse
  ): zio.aws.iot.model.ListDomainConfigurationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
