package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListFleetMetricsResponse(
    fleetMetrics: Option[Iterable[zio.aws.iot.model.FleetMetricNameAndArn]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListFleetMetricsResponse = {
    import ListFleetMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListFleetMetricsResponse
      .builder()
      .optionallyWith(
        fleetMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fleetMetrics)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListFleetMetricsResponse.ReadOnly =
    zio.aws.iot.model.ListFleetMetricsResponse.wrap(buildAwsValue())
}
object ListFleetMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListFleetMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListFleetMetricsResponse =
      zio.aws.iot.model.ListFleetMetricsResponse(
        fleetMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fleetMetrics
        : Option[List[zio.aws.iot.model.FleetMetricNameAndArn.ReadOnly]]
    def nextToken: Option[NextToken]
    def getFleetMetrics: ZIO[Any, AwsError, List[
      zio.aws.iot.model.FleetMetricNameAndArn.ReadOnly
    ]] = AwsError.unwrapOptionField("fleetMetrics", fleetMetrics)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListFleetMetricsResponse
  ) extends zio.aws.iot.model.ListFleetMetricsResponse.ReadOnly {
    override val fleetMetrics
        : Option[List[zio.aws.iot.model.FleetMetricNameAndArn.ReadOnly]] = scala
      .Option(impl.fleetMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.FleetMetricNameAndArn.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListFleetMetricsResponse
  ): zio.aws.iot.model.ListFleetMetricsResponse.ReadOnly = new Wrapper(impl)
}
