package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  NextToken,
  NamespaceId,
  ThingName,
  JobId,
  LaserMaxResults
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListJobExecutionsForThingRequest(
    thingName: ThingName,
    status: Option[zio.aws.iot.model.JobExecutionStatus] = None,
    namespaceId: Option[NamespaceId] = None,
    maxResults: Option[LaserMaxResults] = None,
    nextToken: Option[NextToken] = None,
    jobId: Option[JobId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest = {
    import ListJobExecutionsForThingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest
      .builder()
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        namespaceId.map(value => NamespaceId.unwrap(value): java.lang.String)
      )(_.namespaceId)
      .optionallyWith(
        maxResults.map(value => LaserMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListJobExecutionsForThingRequest.ReadOnly =
    zio.aws.iot.model.ListJobExecutionsForThingRequest.wrap(buildAwsValue())
}
object ListJobExecutionsForThingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListJobExecutionsForThingRequest =
      zio.aws.iot.model.ListJobExecutionsForThingRequest(
        thingName,
        status.map(value => value),
        namespaceId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        jobId.map(value => value)
      )
    def thingName: ThingName
    def status: Option[zio.aws.iot.model.JobExecutionStatus]
    def namespaceId: Option[NamespaceId]
    def maxResults: Option[LaserMaxResults]
    def nextToken: Option[NextToken]
    def jobId: Option[JobId]
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.JobExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNamespaceId: ZIO[Any, AwsError, NamespaceId] =
      AwsError.unwrapOptionField("namespaceId", namespaceId)
    def getMaxResults: ZIO[Any, AwsError, LaserMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest
  ) extends zio.aws.iot.model.ListJobExecutionsForThingRequest.ReadOnly {
    override val thingName: ThingName =
      zio.aws.iot.model.primitives.ThingName(impl.thingName())
    override val status: Option[zio.aws.iot.model.JobExecutionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.JobExecutionStatus.wrap(value))
    override val namespaceId: Option[NamespaceId] = scala
      .Option(impl.namespaceId())
      .map(value => zio.aws.iot.model.primitives.NamespaceId(value))
    override val maxResults: Option[LaserMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.LaserMaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.iot.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest
  ): zio.aws.iot.model.ListJobExecutionsForThingRequest.ReadOnly = new Wrapper(
    impl
  )
}
