package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{NextToken, LaserMaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListJobTemplatesRequest(
    maxResults: Option[LaserMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListJobTemplatesRequest = {
    import ListJobTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListJobTemplatesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => LaserMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListJobTemplatesRequest.ReadOnly =
    zio.aws.iot.model.ListJobTemplatesRequest.wrap(buildAwsValue())
}
object ListJobTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListJobTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListJobTemplatesRequest =
      zio.aws.iot.model.ListJobTemplatesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[LaserMaxResults]
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, LaserMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListJobTemplatesRequest
  ) extends zio.aws.iot.model.ListJobTemplatesRequest.ReadOnly {
    override val maxResults: Option[LaserMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.LaserMaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListJobTemplatesRequest
  ): zio.aws.iot.model.ListJobTemplatesRequest.ReadOnly = new Wrapper(impl)
}
