package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ThingGroupId,
  NextToken,
  NamespaceId,
  LaserMaxResults,
  ThingGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListJobsRequest(
    status: Option[zio.aws.iot.model.JobStatus] = None,
    targetSelection: Option[zio.aws.iot.model.TargetSelection] = None,
    maxResults: Option[LaserMaxResults] = None,
    nextToken: Option[NextToken] = None,
    thingGroupName: Option[ThingGroupName] = None,
    thingGroupId: Option[ThingGroupId] = None,
    namespaceId: Option[NamespaceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListJobsRequest = {
    import ListJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListJobsRequest
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(targetSelection.map(value => value.unwrap))(
        _.targetSelection
      )
      .optionallyWith(
        maxResults.map(value => LaserMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        thingGroupName.map(value =>
          ThingGroupName.unwrap(value): java.lang.String
        )
      )(_.thingGroupName)
      .optionallyWith(
        thingGroupId.map(value => ThingGroupId.unwrap(value): java.lang.String)
      )(_.thingGroupId)
      .optionallyWith(
        namespaceId.map(value => NamespaceId.unwrap(value): java.lang.String)
      )(_.namespaceId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListJobsRequest.ReadOnly =
    zio.aws.iot.model.ListJobsRequest.wrap(buildAwsValue())
}
object ListJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListJobsRequest =
      zio.aws.iot.model.ListJobsRequest(
        status.map(value => value),
        targetSelection.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        thingGroupName.map(value => value),
        thingGroupId.map(value => value),
        namespaceId.map(value => value)
      )
    def status: Option[zio.aws.iot.model.JobStatus]
    def targetSelection: Option[zio.aws.iot.model.TargetSelection]
    def maxResults: Option[LaserMaxResults]
    def nextToken: Option[NextToken]
    def thingGroupName: Option[ThingGroupName]
    def thingGroupId: Option[ThingGroupId]
    def namespaceId: Option[NamespaceId]
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTargetSelection
        : ZIO[Any, AwsError, zio.aws.iot.model.TargetSelection] =
      AwsError.unwrapOptionField("targetSelection", targetSelection)
    def getMaxResults: ZIO[Any, AwsError, LaserMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getThingGroupName: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("thingGroupName", thingGroupName)
    def getThingGroupId: ZIO[Any, AwsError, ThingGroupId] =
      AwsError.unwrapOptionField("thingGroupId", thingGroupId)
    def getNamespaceId: ZIO[Any, AwsError, NamespaceId] =
      AwsError.unwrapOptionField("namespaceId", namespaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListJobsRequest
  ) extends zio.aws.iot.model.ListJobsRequest.ReadOnly {
    override val status: Option[zio.aws.iot.model.JobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.JobStatus.wrap(value))
    override val targetSelection: Option[zio.aws.iot.model.TargetSelection] =
      scala
        .Option(impl.targetSelection())
        .map(value => zio.aws.iot.model.TargetSelection.wrap(value))
    override val maxResults: Option[LaserMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.LaserMaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val thingGroupName: Option[ThingGroupName] = scala
      .Option(impl.thingGroupName())
      .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val thingGroupId: Option[ThingGroupId] = scala
      .Option(impl.thingGroupId())
      .map(value => zio.aws.iot.model.primitives.ThingGroupId(value))
    override val namespaceId: Option[NamespaceId] = scala
      .Option(impl.namespaceId())
      .map(value => zio.aws.iot.model.primitives.NamespaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListJobsRequest
  ): zio.aws.iot.model.ListJobsRequest.ReadOnly = new Wrapper(impl)
}
