package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListMitigationActionsResponse(
    actionIdentifiers: Option[
      Iterable[zio.aws.iot.model.MitigationActionIdentifier]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListMitigationActionsResponse = {
    import ListMitigationActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListMitigationActionsResponse
      .builder()
      .optionallyWith(
        actionIdentifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actionIdentifiers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListMitigationActionsResponse.ReadOnly =
    zio.aws.iot.model.ListMitigationActionsResponse.wrap(buildAwsValue())
}
object ListMitigationActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListMitigationActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListMitigationActionsResponse =
      zio.aws.iot.model.ListMitigationActionsResponse(
        actionIdentifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def actionIdentifiers
        : Option[List[zio.aws.iot.model.MitigationActionIdentifier.ReadOnly]]
    def nextToken: Option[NextToken]
    def getActionIdentifiers: ZIO[Any, AwsError, List[
      zio.aws.iot.model.MitigationActionIdentifier.ReadOnly
    ]] = AwsError.unwrapOptionField("actionIdentifiers", actionIdentifiers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListMitigationActionsResponse
  ) extends zio.aws.iot.model.ListMitigationActionsResponse.ReadOnly {
    override val actionIdentifiers
        : Option[List[zio.aws.iot.model.MitigationActionIdentifier.ReadOnly]] =
      scala
        .Option(impl.actionIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.MitigationActionIdentifier.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListMitigationActionsResponse
  ): zio.aws.iot.model.ListMitigationActionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
