package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListOtaUpdatesResponse(
    otaUpdates: Option[Iterable[zio.aws.iot.model.OTAUpdateSummary]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse = {
    import ListOtaUpdatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse
      .builder()
      .optionallyWith(
        otaUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.otaUpdates)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListOtaUpdatesResponse.ReadOnly =
    zio.aws.iot.model.ListOtaUpdatesResponse.wrap(buildAwsValue())
}
object ListOtaUpdatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListOtaUpdatesResponse =
      zio.aws.iot.model.ListOtaUpdatesResponse(
        otaUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def otaUpdates: Option[List[zio.aws.iot.model.OTAUpdateSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getOtaUpdates: ZIO[Any, AwsError, List[
      zio.aws.iot.model.OTAUpdateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("otaUpdates", otaUpdates)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse
  ) extends zio.aws.iot.model.ListOtaUpdatesResponse.ReadOnly {
    override val otaUpdates
        : Option[List[zio.aws.iot.model.OTAUpdateSummary.ReadOnly]] = scala
      .Option(impl.otaUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.OTAUpdateSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse
  ): zio.aws.iot.model.ListOtaUpdatesResponse.ReadOnly = new Wrapper(impl)
}
