package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPolicyVersionsResponse(
    policyVersions: Option[Iterable[zio.aws.iot.model.PolicyVersion]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListPolicyVersionsResponse = {
    import ListPolicyVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListPolicyVersionsResponse
      .builder()
      .optionallyWith(
        policyVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyVersions)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListPolicyVersionsResponse.ReadOnly =
    zio.aws.iot.model.ListPolicyVersionsResponse.wrap(buildAwsValue())
}
object ListPolicyVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListPolicyVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListPolicyVersionsResponse =
      zio.aws.iot.model.ListPolicyVersionsResponse(
        policyVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def policyVersions: Option[List[zio.aws.iot.model.PolicyVersion.ReadOnly]]
    def getPolicyVersions
        : ZIO[Any, AwsError, List[zio.aws.iot.model.PolicyVersion.ReadOnly]] =
      AwsError.unwrapOptionField("policyVersions", policyVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListPolicyVersionsResponse
  ) extends zio.aws.iot.model.ListPolicyVersionsResponse.ReadOnly {
    override val policyVersions
        : Option[List[zio.aws.iot.model.PolicyVersion.ReadOnly]] = scala
      .Option(impl.policyVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.PolicyVersion.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListPolicyVersionsResponse
  ): zio.aws.iot.model.ListPolicyVersionsResponse.ReadOnly = new Wrapper(impl)
}
