package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{Principal, RegistryMaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPrincipalThingsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[RegistryMaxResults] = None,
    principal: Principal
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest = {
    import ListPrincipalThingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => RegistryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .principal(Principal.unwrap(principal): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListPrincipalThingsRequest.ReadOnly =
    zio.aws.iot.model.ListPrincipalThingsRequest.wrap(buildAwsValue())
}
object ListPrincipalThingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListPrincipalThingsRequest =
      zio.aws.iot.model.ListPrincipalThingsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        principal
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[RegistryMaxResults]
    def principal: Principal
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, RegistryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getPrincipal: ZIO[Any, Nothing, Principal] = ZIO.succeed(principal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest
  ) extends zio.aws.iot.model.ListPrincipalThingsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Option[RegistryMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.RegistryMaxResults(value))
    override val principal: Principal =
      zio.aws.iot.model.primitives.Principal(impl.principal())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest
  ): zio.aws.iot.model.ListPrincipalThingsRequest.ReadOnly = new Wrapper(impl)
}
