package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListProvisioningTemplateVersionsResponse(
    versions: Option[
      Iterable[zio.aws.iot.model.ProvisioningTemplateVersionSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsResponse = {
    import ListProvisioningTemplateVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsResponse
      .builder()
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.versions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListProvisioningTemplateVersionsResponse.ReadOnly =
    zio.aws.iot.model.ListProvisioningTemplateVersionsResponse
      .wrap(buildAwsValue())
}
object ListProvisioningTemplateVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListProvisioningTemplateVersionsResponse =
      zio.aws.iot.model.ListProvisioningTemplateVersionsResponse(
        versions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def versions: Option[
      List[zio.aws.iot.model.ProvisioningTemplateVersionSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getVersions: ZIO[Any, AwsError, List[
      zio.aws.iot.model.ProvisioningTemplateVersionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("versions", versions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsResponse
  ) extends zio.aws.iot.model.ListProvisioningTemplateVersionsResponse.ReadOnly {
    override val versions: Option[
      List[zio.aws.iot.model.ProvisioningTemplateVersionSummary.ReadOnly]
    ] = scala
      .Option(impl.versions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.ProvisioningTemplateVersionSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsResponse
  ): zio.aws.iot.model.ListProvisioningTemplateVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
