package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListProvisioningTemplatesResponse(
    templates: Option[Iterable[zio.aws.iot.model.ProvisioningTemplateSummary]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesResponse = {
    import ListProvisioningTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesResponse
      .builder()
      .optionallyWith(
        templates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.templates)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListProvisioningTemplatesResponse.ReadOnly =
    zio.aws.iot.model.ListProvisioningTemplatesResponse.wrap(buildAwsValue())
}
object ListProvisioningTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListProvisioningTemplatesResponse =
      zio.aws.iot.model.ListProvisioningTemplatesResponse(
        templates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def templates
        : Option[List[zio.aws.iot.model.ProvisioningTemplateSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getTemplates: ZIO[Any, AwsError, List[
      zio.aws.iot.model.ProvisioningTemplateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("templates", templates)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesResponse
  ) extends zio.aws.iot.model.ListProvisioningTemplatesResponse.ReadOnly {
    override val templates
        : Option[List[zio.aws.iot.model.ProvisioningTemplateSummary.ReadOnly]] =
      scala
        .Option(impl.templates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.ProvisioningTemplateSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesResponse
  ): zio.aws.iot.model.ListProvisioningTemplatesResponse.ReadOnly = new Wrapper(
    impl
  )
}
