package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{AscendingOrder, Marker, PageSize}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListRoleAliasesRequest(
    pageSize: Option[PageSize] = None,
    marker: Option[Marker] = None,
    ascendingOrder: Option[AscendingOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListRoleAliasesRequest = {
    import ListRoleAliasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListRoleAliasesRequest
      .builder()
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        ascendingOrder.map(value =>
          AscendingOrder.unwrap(value): java.lang.Boolean
        )
      )(_.ascendingOrder)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListRoleAliasesRequest.ReadOnly =
    zio.aws.iot.model.ListRoleAliasesRequest.wrap(buildAwsValue())
}
object ListRoleAliasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListRoleAliasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListRoleAliasesRequest =
      zio.aws.iot.model.ListRoleAliasesRequest(
        pageSize.map(value => value),
        marker.map(value => value),
        ascendingOrder.map(value => value)
      )
    def pageSize: Option[PageSize]
    def marker: Option[Marker]
    def ascendingOrder: Option[AscendingOrder]
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getAscendingOrder: ZIO[Any, AwsError, AscendingOrder] =
      AwsError.unwrapOptionField("ascendingOrder", ascendingOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListRoleAliasesRequest
  ) extends zio.aws.iot.model.ListRoleAliasesRequest.ReadOnly {
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.iot.model.primitives.PageSize(value))
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
    override val ascendingOrder: Option[AscendingOrder] = scala
      .Option(impl.ascendingOrder())
      .map(value => zio.aws.iot.model.primitives.AscendingOrder(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListRoleAliasesRequest
  ): zio.aws.iot.model.ListRoleAliasesRequest.ReadOnly = new Wrapper(impl)
}
