package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{MaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListScheduledAuditsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListScheduledAuditsRequest = {
    import ListScheduledAuditsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListScheduledAuditsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListScheduledAuditsRequest.ReadOnly =
    zio.aws.iot.model.ListScheduledAuditsRequest.wrap(buildAwsValue())
}
object ListScheduledAuditsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListScheduledAuditsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListScheduledAuditsRequest =
      zio.aws.iot.model.ListScheduledAuditsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListScheduledAuditsRequest
  ) extends zio.aws.iot.model.ListScheduledAuditsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListScheduledAuditsRequest
  ): zio.aws.iot.model.ListScheduledAuditsRequest.ReadOnly = new Wrapper(impl)
}
