package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{MaxResults, NextToken, SecurityProfileName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTargetsForSecurityProfileRequest(
    securityProfileName: SecurityProfileName,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest = {
    import ListTargetsForSecurityProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest
      .builder()
      .securityProfileName(
        SecurityProfileName.unwrap(securityProfileName): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListTargetsForSecurityProfileRequest.ReadOnly =
    zio.aws.iot.model.ListTargetsForSecurityProfileRequest.wrap(buildAwsValue())
}
object ListTargetsForSecurityProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListTargetsForSecurityProfileRequest =
      zio.aws.iot.model.ListTargetsForSecurityProfileRequest(
        securityProfileName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def securityProfileName: SecurityProfileName
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getSecurityProfileName: ZIO[Any, Nothing, SecurityProfileName] =
      ZIO.succeed(securityProfileName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest
  ) extends zio.aws.iot.model.ListTargetsForSecurityProfileRequest.ReadOnly {
    override val securityProfileName: SecurityProfileName =
      zio.aws.iot.model.primitives
        .SecurityProfileName(impl.securityProfileName())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest
  ): zio.aws.iot.model.ListTargetsForSecurityProfileRequest.ReadOnly =
    new Wrapper(impl)
}
