package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListThingGroupsResponse(
    thingGroups: Option[Iterable[zio.aws.iot.model.GroupNameAndArn]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingGroupsResponse = {
    import ListThingGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingGroupsResponse
      .builder()
      .optionallyWith(
        thingGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.thingGroups)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListThingGroupsResponse.ReadOnly =
    zio.aws.iot.model.ListThingGroupsResponse.wrap(buildAwsValue())
}
object ListThingGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingGroupsResponse =
      zio.aws.iot.model.ListThingGroupsResponse(
        thingGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def thingGroups: Option[List[zio.aws.iot.model.GroupNameAndArn.ReadOnly]]
    def nextToken: Option[NextToken]
    def getThingGroups
        : ZIO[Any, AwsError, List[zio.aws.iot.model.GroupNameAndArn.ReadOnly]] =
      AwsError.unwrapOptionField("thingGroups", thingGroups)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingGroupsResponse
  ) extends zio.aws.iot.model.ListThingGroupsResponse.ReadOnly {
    override val thingGroups
        : Option[List[zio.aws.iot.model.GroupNameAndArn.ReadOnly]] = scala
      .Option(impl.thingGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.GroupNameAndArn.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingGroupsResponse
  ): zio.aws.iot.model.ListThingGroupsResponse.ReadOnly = new Wrapper(impl)
}
