package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{ThingName, RegistryMaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListThingPrincipalsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[RegistryMaxResults] = None,
    thingName: ThingName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingPrincipalsRequest = {
    import ListThingPrincipalsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingPrincipalsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => RegistryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListThingPrincipalsRequest.ReadOnly =
    zio.aws.iot.model.ListThingPrincipalsRequest.wrap(buildAwsValue())
}
object ListThingPrincipalsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingPrincipalsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingPrincipalsRequest =
      zio.aws.iot.model.ListThingPrincipalsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        thingName
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[RegistryMaxResults]
    def thingName: ThingName
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, RegistryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingPrincipalsRequest
  ) extends zio.aws.iot.model.ListThingPrincipalsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Option[RegistryMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.RegistryMaxResults(value))
    override val thingName: ThingName =
      zio.aws.iot.model.primitives.ThingName(impl.thingName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingPrincipalsRequest
  ): zio.aws.iot.model.ListThingPrincipalsRequest.ReadOnly = new Wrapper(impl)
}
