package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{NextToken, TopicRuleDestinationMaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTopicRuleDestinationsRequest(
    maxResults: Option[TopicRuleDestinationMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsRequest = {
    import ListTopicRuleDestinationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          TopicRuleDestinationMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListTopicRuleDestinationsRequest.ReadOnly =
    zio.aws.iot.model.ListTopicRuleDestinationsRequest.wrap(buildAwsValue())
}
object ListTopicRuleDestinationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListTopicRuleDestinationsRequest =
      zio.aws.iot.model.ListTopicRuleDestinationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[TopicRuleDestinationMaxResults]
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, TopicRuleDestinationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsRequest
  ) extends zio.aws.iot.model.ListTopicRuleDestinationsRequest.ReadOnly {
    override val maxResults: Option[TopicRuleDestinationMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.iot.model.primitives.TopicRuleDestinationMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsRequest
  ): zio.aws.iot.model.ListTopicRuleDestinationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
