package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  IsDisabled,
  NextToken,
  TopicRuleMaxResults,
  Topic
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTopicRulesRequest(
    topic: Option[Topic] = None,
    maxResults: Option[TopicRuleMaxResults] = None,
    nextToken: Option[NextToken] = None,
    ruleDisabled: Option[IsDisabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListTopicRulesRequest = {
    import ListTopicRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListTopicRulesRequest
      .builder()
      .optionallyWith(
        topic.map(value => Topic.unwrap(value): java.lang.String)
      )(_.topic)
      .optionallyWith(
        maxResults.map(value => TopicRuleMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        ruleDisabled.map(value => IsDisabled.unwrap(value): java.lang.Boolean)
      )(_.ruleDisabled)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListTopicRulesRequest.ReadOnly =
    zio.aws.iot.model.ListTopicRulesRequest.wrap(buildAwsValue())
}
object ListTopicRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListTopicRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListTopicRulesRequest =
      zio.aws.iot.model.ListTopicRulesRequest(
        topic.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        ruleDisabled.map(value => value)
      )
    def topic: Option[Topic]
    def maxResults: Option[TopicRuleMaxResults]
    def nextToken: Option[NextToken]
    def ruleDisabled: Option[IsDisabled]
    def getTopic: ZIO[Any, AwsError, Topic] =
      AwsError.unwrapOptionField("topic", topic)
    def getMaxResults: ZIO[Any, AwsError, TopicRuleMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRuleDisabled: ZIO[Any, AwsError, IsDisabled] =
      AwsError.unwrapOptionField("ruleDisabled", ruleDisabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListTopicRulesRequest
  ) extends zio.aws.iot.model.ListTopicRulesRequest.ReadOnly {
    override val topic: Option[Topic] = scala
      .Option(impl.topic())
      .map(value => zio.aws.iot.model.primitives.Topic(value))
    override val maxResults: Option[TopicRuleMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.TopicRuleMaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val ruleDisabled: Option[IsDisabled] = scala
      .Option(impl.ruleDisabled())
      .map(value => zio.aws.iot.model.primitives.IsDisabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListTopicRulesRequest
  ): zio.aws.iot.model.ListTopicRulesRequest.ReadOnly = new Wrapper(impl)
}
